# SNN BRX - Bricks Builder Child Theme

[![GPL-3.0](https://img.shields.io/github/license/ESKYoung/shields-io-visitor-counter?logo=GNU&logoColor=FFFFFF)](https://github.com/sinanisler/snn-brx-child-theme/blob/main/license.txt)
[![Gmail Badge](https://img.shields.io/badge/-Download_Latest_Release-29903b?style=flat&logo=Download&logoColor=white)](https://sinanisler.com/snn-brx-download)
[![Ask DeepWiki](https://deepwiki.com/badge.svg)](https://deepwiki.com/sinanisler/snn-brx-child-theme)





**SNN-BRX - Build Smarter. Build Faster. Build Better.**



# SNN-BRX: The Ultimate Child Theme for Bricks Builder

SNN-BRX is a professional and powerful child theme designed to be the essential building suite for agencies and professionals using Bricks Builder. It streamlines your Bricks Builder projects by offering a comprehensive collection of features and tools, all within a single, robust child theme. Say goodbye to plugin overload and embrace a more efficient, performant, and unified website building experience.

## Key Features

SNN-BRX aims to replace the need for numerous individual plugins by integrating core functionalities directly into the theme. Here's a glimpse of what SNN-BRX offers:

*   **White Labeling:** Brand the theme as your own.
*   **Custom Post Types:** Easily create and manage custom post types.
*   **Custom Fields & Repeaters:** Build custom fields and repeater fields with an intuitive interface.
*   **Custom Taxonomies:** Register and manage custom taxonomies like categories and tags.
*   **Security Settings:** Enhance your website's security.
*   **Block Editor Settings:** Optimize the WordPress Block Editor.
*   **Disable File Editing:** Prevent direct file editing in the WordPress dashboard.
*   **Disable WP JSON (if not logged in):** Improve security by disabling JSON endpoints for non-logged-in users.
*   **SMTP Settings & Mail Logs:** Configure transactional emails and track mail activity.
*   **404 Logs:** Monitor and manage your website's 404 errors.
*   **Custom Login/Register Page:** Create branded login and registration experiences.
*   **301 Redirects & Logs:** Manage redirects and track their usage.
*   **Remove WP Version:** Obscure your WordPress version for added security.
*   **WP Revision Limit:** Control the number of post revisions to optimize database performance.
*   **GSAP Animations:** Integrate powerful GreenSock Animation Platform (GSAP) animations with dedicated elements and easy-to-use controls for various animation types (Scroll Trigger, SplitText, Entrance, Loop) and responsive options.
*   **Lottie Element:** Seamlessly embed Lottie animations.
*   **OSM Map Element:** Add OpenStreetMap elements to your designs.
*   **Color Sync Variables:** A revolutionary feature that synchronizes global color variables across Bricks Builder, ensuring consistency and ease of use. Supports automatic generation of color shades.
*   **AI Ready:** Leverage AI for text, rich text, headings, and CSS generation with OpenAI and OpenRouter API support. Includes a Bulk AI Content Editor for efficient content creation and refinement.
*   **SNN Settings Panel:** A centralized hub for managing all theme features.
*   **GPL Licensed:** Distributed under the GNU General Public License (GPL).
*   **Auto Update:** Update the theme directly from GitHub with a single click.
*   **Global Classes and Vars:** Manage global classes and variables for consistent styling.
*   **All Custom Elements:** Access a suite of custom-built elements for enhanced design capabilities.
*   **Cookie Banner:** Implement a cookie consent banner.
*   **Accessibility Widget:** Improve website accessibility.
*   **Media Library Assistant:** Enhance your media management.
*   **Role Manager:** Control user roles and permissions.
*   **Code Snippets:** Add custom code snippets easily.

## Why SNN-BRX?

The primary goal behind SNN-BRX is to **achieve a more efficient and simplified website building process.** By consolidating the functionalities of over 25 plugins into one child theme, SNN-BRX significantly reduces plugin dependency, saving you valuable time, resources, and improving website performance. Its modular design ensures that you only use the features you need, preventing unnecessary server load.

## Getting Started

1.  **Installation:** Install SNN-BRX as a child theme to your Bricks Builder installation.
2.  **Configuration:** Navigate to the "SNN Settings" panel in your WordPress dashboard to enable and configure the features you require.
3.  **Explore Features:** Dive into the extensive features, from advanced animations and AI content generation to robust security and redirect management.


### Custom Post Types, Fields, and Taxonomies

SNN-BRX provides an intuitive admin interface to effortlessly create and manage:

*   **Custom Post Types:** Define names, slugs, visibility, and supported features (title, editor, thumbnails).
*   **Custom Fields:** Assign various field types (text, number, date, media) to post types or taxonomies, with support for repeater fields.
*   **Custom Taxonomies:** Set up hierarchical or tag-based taxonomies and link them to your post types.

### GSAP and Lottie Animations

Bring your designs to life with powerful animations:

*   **GSAP Integration:** Animate sections, containers, blocks, and text elements with ease. Supports Scroll Trigger, SplitText, Entrance Animations, and Loop Animations with customizable duration and delay.
*   **Extensive Animation Library:** Access a vast array of pre-defined GSAP animations, including fades, slides, zooms, rotations, bounces, and more.
*   **Responsive Animations:** Control animation visibility across different devices.
*   **Lottie Support:** Embed Lottie animations seamlessly.

### AI Ready Features

Supercharge your content creation:

*   **AI Text Generation:** Generate or refine text, rich text, headings, and CSS directly within the Bricks Builder editor using OpenAI or OpenRouter APIs.
*   **Bulk AI Content Editor:** Edit and generate content for multiple elements simultaneously, fix grammar, and adjust writing style with AI assistance.
*   **AI Design Generator (ALPHA):** Create random creative designs with AI inside Bricks Builder Editor.

### SNN Color Sync Variables

Experience a new level of color management:

*   **Global Color Synchronization:** Ensures that global color variables created with SNN-BRX are consistently available and visually represented across all Bricks Builder color palettes.
*   **Automatic Shade Generation:** Create automatic light and dark shades of your chosen colors by simply setting a shade count.
*   **Flexible Color Units:** Supports hex colors and any valid CSS color units.

### Security and Optimization

Focus on building, not managing plugins:

*   **Reduced Plugin Count:** Eliminates the need for 25+ individual plugins.
*   **Enhanced Security:** Features like disabling file editing, obscuring WP version, and JSON endpoint control contribute to a more secure website.
*   **Performance Optimization:** Modular design and features like WP Revision limiting help maintain optimal performance.

## Changelog

Refer to the [Changelog](https://github.com/sinanisler/snn-brx-child-theme/releases) for the latest updates and improvements.

## Roadmap

Stay informed about future developments and planned features on the [Roadmap](https://sinanisler.com/snn-brx/#roadmap).

## Support and Community

*   **FAQs:** Find answers to frequently asked questions on the [FAQs](https://sinanisler.com/snn-brx/#faqs/) page.
*   **Bug Report:** Report any issues you encounter via the [Bug Report](https://github.com/sinanisler/snn-brx-child-theme/issues) section.
*   **Discussions:** Engage with the community and share your experiences in the [Discussions](https://github.com/sinanisler/snn-brx-child-theme/discussions/) forum.
