<?php
namespace Bricks;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class I18n {
	public static function get_frontend_i18n() {
		return [
			'openAccordion'    => __( 'Open accordion', 'bricks' ),
			'openMobileMenu'   => __( 'Open mobile menu', 'bricks' ),
			'closeMobileMenu'  => __( 'Close mobile menu', 'bricks' ),
			'showPassword'     => __( 'Show password', 'bricks' ),
			'hidePassword'     => __( 'Hide password', 'bricks' ),
			'prevSlide'        => __( 'Previous slide', 'bricks' ),
			'nextSlide'        => __( 'Next slide', 'bricks' ),
			'firstSlide'       => __( 'Go to first slide', 'bricks' ),
			'lastSlide'        => __( 'Go to last slide', 'bricks' ),
			/* translators: %s: slide number */
			'slideX'           => __( 'Go to slide %s', 'bricks' ),
			'play'             => __( 'Start autoplay', 'bricks' ),
			'pause'            => __( 'Pause autoplay', 'bricks' ),
			'splide'           => [
				'carousel'   => __( 'carousel', 'bricks' ),
				'select'     => __( 'Select a slide to show', 'bricks' ),
				'slide'      => __( 'slide', 'bricks' ),
				/* translators: %1$s: current slide number, %2$s: total slides */
				'slideLabel' => __( '%1$s of %2$s', 'bricks' ),
			],
			'swiper'           => [
				/* translators: {{index}}: current slide number, {{slidesLength}}: total slides */
				'slideLabelMessage' => __( '{{index}} / {{slidesLength}}', 'bricks' ),
			],
			'noLocationsFound' => __( 'No locations found', 'bricks' ),
			'locationTitle'    => __( 'Location title', 'bricks' ),
			'locationSubtitle' => __( 'Location subtitle', 'bricks' ),
			'locationContent'  => __( 'Location content', 'bricks' ),
		];
	}

	public static function get_admin_i18n() {
		return [
			'capability'                              => __( 'Capability', 'bricks' ),
			'capabilityKey'                           => __( 'Key', 'bricks' ),
			'capabilityName'                          => __( 'Name', 'bricks' ),
			'capabilityNameRequired'                  => __( 'Name is required', 'bricks' ),
			'cleanupAllOrphanedElements'              => __( 'Clean up all orphaned elements', 'bricks' ),
			'close'                                   => __( 'Close', 'bricks' ),
			'confirmCleanupOrphanedElements'          => __( 'Are you sure you want to remove all orphaned elements from your site? This action cannot be undone. Please perform a backup of your site before you proceed.', 'bricks' ),
			'confirmDeleteCapability'                 => __( 'You are about to delete this capability. Do you wish to proceed?', 'bricks' ),
			'confirmResetSettings'                    => __( 'You are about to reset all Bricks global settings. Do you wish to proceed?', 'bricks' ),
			'confirmDropFormSubmissionsTable'         => __( 'You are about to delete all form submissions (including the database table). Do you wish to proceed?', 'bricks' ),
			'confirmResetFormSubmissionsTable'        => __( 'You are about to delete all form submissions. Do you wish to proceed?', 'bricks' ),
			'confirmResetFormSubmissionsFormId'       => sprintf( __( 'You are about to delete all form submissions of form ID %s. Do you wish to proceed?', 'bricks' ), '[form_id]' ),
			'confirmDeleteTemplateScreenshots'        => __( 'You are about to delete all template screenshots. Not your featured images, though. Do you wish to proceed?', 'bricks' ),
			'confirmReindexFilters'                   => __( 'You are about to regenerate indexes for all query filters. Do you wish to proceed?', 'bricks' ),
			'confirmRegenerateCodeSignatures'         => __( 'You are about to regenerate code signatures for all executable code on your website. Please ensure you have a recent backup before continuing. Do you wish to proceed?', 'bricks' ),
			'confirmRemoveAllIndexJobs'               => __( 'You are about to remove all index jobs. Do you wish to proceed?', 'bricks' ),
			'confirmTriggerIndexJob'                  => __( 'You are about to trigger Index Job. Do you wish to proceed?', 'bricks' ),
			'confirmFixElementDB'                     => __( 'You are about to fix the element database. Do you wish to proceed?', 'bricks' ),
			'customCapabilities'                      => __( 'Custom capabilities', 'bricks' ),
			'customCapabilitiesDescription'           => __( 'Once done editing, click the "Save Settings" button at the bottom below to persist your changes.', 'bricks' ),
			'default'                                 => __( 'Default', 'bricks' ),
			'defaultCapabilities'                     => __( 'Default capabilities', 'bricks' ),
			'delete'                                  => __( 'Delete', 'bricks' ),
			'deleteSelected'                          => __( 'Delete selected', 'bricks' ),
			'description'                             => __( 'Description', 'bricks' ),
			'duplicate'                               => __( 'Duplicate', 'bricks' ),
			'edit'                                    => __( 'Edit', 'bricks' ),
			'editCapability'                          => __( 'Edit capability', 'bricks' ),
			'errorOccurred'                           => __( 'An error occurred.', 'bricks' ),
			'errorOccurredCleaningUpOrphanedElements' => __( 'An error occurred while cleaning up orphaned elements.', 'bricks' ),
			'errorOccurredScanningOrphanedElements'   => __( 'An error occurred while scanning for orphaned elements.', 'bricks' ),
			'enableAll'                               => __( 'Enable all', 'bricks' ),
			'formSubmissionsSearchPlaceholder'        => __( 'Form data', 'bricks' ),
			'globalElementsConvertConfirm'            => __( 'Do you want to unlink all nestable global elements?', 'bricks' ),
			'selectItems'                             => __( 'Select items', 'bricks' ),
			'searchItems'                             => __( 'Add / Search for', 'bricks' ),
			'selectTemplates'                         => __( 'Select templates', 'bricks' ),
			'searchTemplates'                         => __( 'Add / Search for templates', 'bricks' ),
			'selectColor'                             => __( 'Select color', 'bricks' ),
			'selectPosts'                             => __( 'Select posts/pages', 'bricks' ),
			'searchPosts'                             => __( 'Search posts/pages', 'bricks' ),
			'typeToSearch'                            => __( 'Type to search', 'bricks' ),
			'results'                                 => __( 'Results', 'bricks' ),
			'remove'                                  => __( 'Remove', 'bricks' ),
			'searching'                               => __( 'Searching', 'bricks' ) . ' ...',
			'noResults'                               => __( 'No results found', 'bricks' ),
			'searchError'                             => __( 'Error loading results', 'bricks' ),
			'minSearchLength'                         => __( 'Please enter at least 2 characters', 'bricks' ) . ' ...',
			'newCapability'                           => __( 'New capability', 'bricks' ),
			'noOrphanedElementsFound'                 => __( 'No orphaned elements found.', 'bricks' ),
			// translators: %d: Number of orphaned elements found in this specific post
			'orphanedElementsCountMessage'            => __( '%d orphaned elements found', 'bricks' ),
			// translators: %1$d: Number of orphaned elements found, %2$d: Number of posts affected
			'orphanedElementsFoundMessage'            => __( '%1$d orphaned elements found across %2$d posts. Click "Clean up all orphaned elements" to remove all orphaned elements from your site. Please backup your site before you proceed.', 'bricks' ),
			'orphanedElementsReview'                  => __( 'Orphaned elements review', 'bricks' ),
			'removingIndexJobsInfo'                   => __( 'Do not close this window, the process is running in the background.', 'bricks' ),
			'updateCapability'                        => __( 'Close', 'bricks' ),
			'view'                                    => __( 'View', 'bricks' ),
			'saveChanges'                             => __( 'Save changes', 'bricks' ),
			'saveSettingsToApplyChanges'              => __( 'Make sure to save settings after closing this modal to apply changes', 'bricks' ),
			// Gutenberg
			'editWithBricks'                          => // translators: %s: "Bricks" (theme name)
				sprintf( __( 'Edit with %s', 'bricks' ), 'Bricks' ),
			'useDefaultEditor'                        => __( 'Use block editor', 'bricks' ),
			// translators: %s: "Bricks" (theme name)
			'bricksActiveMessage'                     => sprintf( __( 'This page is built with %s.', 'bricks' ), 'Bricks' ),
		];
	}

	public static function get_builder_i18n() {
		return [
			'accept'                                      => __( 'Accept', 'bricks' ),
			'action'                                      => __( 'Action', 'bricks' ),
			'actions'                                     => __( 'Actions', 'bricks' ),
			'active'                                      => __( 'Active', 'bricks' ),
			'activeClass'                                 => __( 'Active class', 'bricks' ),
			'activeClasses'                               => __( 'Active classes', 'bricks' ),
			'activeStyles'                                => __( 'Active styles', 'bricks' ),
			'add'                                         => __( 'Add', 'bricks' ),
			'addToFavorites'                              => __( 'Add to favorites', 'bricks' ),
			'added'                                       => __( 'Added', 'bricks' ),
			'addImages'                                   => __( 'Add images', 'bricks' ),
			'addItem'                                     => __( 'Add Item', 'bricks' ),
			'addPrefix'                                   => __( 'Add prefix', 'bricks' ),
			'addSuffix'                                   => __( 'Add suffix', 'bricks' ),
			'addToIconSet'                                => __( 'Add to icon set', 'bricks' ),
			'ajaxLoader'                                  => __( 'AJAX loader', 'bricks' ),
			'ajaxLoaderDesc'                              => __( 'Shows when using infinite scroll, load more interaction, AJAX pagination.', 'bricks' ),
			'ajaxLoaderSelector'                          => __( 'CSS selector', 'bricks' ),
			'ajaxLoaderSelectorDesc'                      => __( 'CSS selector of the element to insert the AJAX loader into.', 'bricks' ),
			'ajaxLoaderAnimation'                         => __( 'Animation', 'bricks' ),

			'align'                                       => __( 'Align', 'bricks' ),
			'alignItems'                                  => __( 'Align items', 'bricks' ),
			'all'                                         => __( 'All', 'bricks' ),
			'alpha'                                       => __( 'Transparency', 'bricks' ),
			'alphabetically'                              => __( 'Alphabetically', 'bricks' ),
			'and'                                         => __( 'And', 'bricks' ),
			'angle'                                       => __( 'Angle in °', 'bricks' ),
			'any'                                         => __( 'Any', 'bricks' ),
			'anyBreakpoint'                               => __( 'Any breakpoint', 'bricks' ),
			'apply'                                       => __( 'Apply', 'bricks' ),
			'applyTo'                                     => __( 'Apply to', 'bricks' ),
			'archive'                                     => __( 'Archive', 'bricks' ),
			'arrows'                                      => __( 'Arrows', 'bricks' ),
			'ascending'                                   => __( 'Ascending', 'bricks' ),
			'auto'                                        => __( 'Auto', 'bricks' ),
			'author'                                      => __( 'Author', 'bricks' ),
			'attachment'                                  => __( 'Attachment', 'bricks' ),
			'attribute'                                   => __( 'Attribute', 'bricks' ),
			'attributes'                                  => __( 'Attributes', 'bricks' ),
			'autosaveBy'                                  => __( 'Autosave by', 'bricks' ),

			'back'                                        => __( 'Back', 'bricks' ),
			'backToIconSets'                              => __( 'Back to icon sets', 'bricks' ),
			'background'                                  => __( 'Background', 'bricks' ),
			'backgroundColor'                             => __( 'Background color', 'bricks' ),
			'backgroundCustomSize'                        => __( 'Background custom size', 'bricks' ),
			'backgroundImage'                             => __( 'Background image', 'bricks' ),
			'backgroundPosition'                          => __( 'Background position', 'bricks' ),
			'backgroundRepeat'                            => __( 'Background repeat', 'bricks' ),
			'backgroundSize'                              => __( 'Background size', 'bricks' ),
			'backgroundAttachment'                        => __( 'Background attachment', 'bricks' ),
			'backgroundBlendMode'                         => __( 'Background blend mode', 'bricks' ),
			'backgroundVideo'                             => __( 'Background video', 'bricks' ),
			'backgroundVideoAspectRatio'                  => __( 'Aspect ratio', 'bricks' ),
			'backgroundVideoStartAt'                      => __( 'Select smallest breakpoint that this video should play at. Preview on frontend.', 'bricks' ),
			'backgroundVideoDescription'                  => __( 'File URL, YouTube/Vimeo URL/ID.', 'bricks' ),
			'backgroundVideoPoster'                       => __( 'Poster image', 'bricks' ),
			'backgroundVideoPosterYouTube'                => __( 'Auto poster', 'bricks' ) . ' (YouTube)',
			'backgroundVideoPosterYouTubeSize'            => __( 'Poster size for YouTube', 'bricks' ),
			'backgroundVideoPosterYouTubeSizePlaceholder' => __( 'Max resolution', 'bricks' ),
			'backToBuilder'                               => __( 'Back to builder', 'bricks' ),
			'backToImportManager'                         => __( 'Back to import manager', 'bricks' ),
			'baseBreakpoint'                              => __( 'Base breakpoint', 'bricks' ),
			'baseline'                                    => __( 'Baseline', 'bricks' ),
			'basic'                                       => __( 'Basic', 'bricks' ),
			'blockquote'                                  => __( 'Blockquote', 'bricks' ),
			'align'                                       => __( 'Align', 'bricks' ),
			'bulletedList'                                => __( 'Bullet List', 'bricks' ),
			'block'                                       => __( 'Block', 'bricks' ),
			'blur'                                        => __( 'Blur', 'bricks' ),
			'bold'                                        => __( 'Bold', 'bricks' ),
			'border'                                      => __( 'Border', 'bricks' ),
			'borderColor'                                 => __( 'Border color', 'bricks' ),
			'bottom'                                      => __( 'Bottom', 'bricks' ),
			'bottomLeft'                                  => __( 'Bottom left', 'bricks' ),
			'bottomCenter'                                => __( 'Bottom center', 'bricks' ),
			'bottomRight'                                 => __( 'Bottom right', 'bricks' ),
			'boxShadow'                                   => __( 'Box shadow', 'bricks' ),
			'breakpoint'                                  => __( 'Breakpoint', 'bricks' ),
			'breakpoints'                                 => __( 'Breakpoints', 'bricks' ),
			'breakpointBaseMessage'                       => __( 'Editing the base breakpoint width affects all media queries.', 'bricks' ),
			'breakpointLabelErrorMessage'                 => __( 'Breakpoint label must start with a letter.', 'bricks' ),
			'breakpointDeleteDescription'                 => __( 'Are you sure that you want to delete this breakpoint?', 'bricks' ),
			'bricksSettings'                              => sprintf( __( '%s settings', 'bricks' ), 'Bricks' ),
			'brightness'                                  => __( 'Brightness', 'bricks' ),
			'browse'                                      => __( 'Browse', 'bricks' ),
			'browseMediaLibrary'                          => __( 'Browse Media Library', 'bricks' ),
			'browseUnsplash'                              => __( 'Browse Unsplash', 'bricks' ),
			'builder'                                     => __( 'Builder', 'bricks' ),
			'builtInIconSets'                             => __( 'Built-in icon sets', 'bricks' ),
			'builderHelpTitle'                            => __( 'Need help? Found a bug? Suggest a feature?', 'bricks' ),
			'builderHelpDescription'                      => sprintf(
				// translators: %s: Bricks support email address (link)
				__( 'Please use your Bricks account email address for all customer support requests. To attach larger files, please send an email directly to %1$s. To see what is currently in development or submit/upvote feature requests please visit our %2$s.', 'bricks' ),
				'<a href="mailto:help@bricksbuilder.io" target="_blank">help@bricksbuilder.io</a>',
				'<a href="https://bricksbuilder.io/roadmap/" target="_blank" rel="noopener">' . __( 'official roadmap', 'bricks' ) . '</a>'
			),
			// translators: %s: Max. upload size (e.g. 2 MB)
			'builderHelpUploadLimitExceeded'              => sprintf( __( 'Your attached files exceed your server max. upload size of %s.', 'bricks' ), size_format( wp_max_upload_size() ) ),
			'builderHelpGmailLimitExceeded'               => __( 'Your attached files exceed the max. upload limit of 25 MB.', 'bricks' ),
			'bulletedlist'                                => __( 'Bulleted list', 'bricks' ),
			'bulkActions'                                 => __( 'Bulk actions', 'bricks' ),
			'bulkEdit'                                    => __( 'Bulk edit', 'bricks' ),
			'bulkEditNotSupported'                        => __( 'Not possible while bulk-editing.', 'bricks' ),
			'bulkEditMoveError'                           => __( 'All selected elements must have the same parent', 'bricks' ),
			'by'                                          => __( 'by', 'bricks' ),

			'cancel'                                      => __( 'Cancel', 'bricks' ),
			'capitalize'                                  => __( 'Capitalize', 'bricks' ),
			'cartCrossSells'                              => __( 'Cart Cross-sells', 'bricks' ),
			'cartCrossSellsQueryDescription'              => __( 'Place this query on the cart page.', 'bricks' ),
			'categories'                                  => __( 'Categories', 'bricks' ),
			'categorize'                                  => __( 'Categorize', 'bricks' ),
			'category'                                    => __( 'Category', 'bricks' ),
			'categoriesDeleted'                           => __( 'Categories deleted', 'bricks' ),
			'category'                                    => __( 'Category', 'bricks' ),
			'categoriesImported'                          => __( 'Categories imported', 'bricks' ),
			'categoryNamePlaceholder'                     => __( 'New category name', 'bricks' ),
			'center'                                      => __( 'Center', 'bricks' ),
			'centerLeft'                                  => __( 'Center left', 'bricks' ),
			'centerCenter'                                => __( 'Center center', 'bricks' ),
			'centerRight'                                 => __( 'Center right', 'bricks' ),
			'childOf'                                     => __( 'Child of', 'bricks' ),
			'childless'                                   => __( 'Childless', 'bricks' ),
			'circle'                                      => __( 'Circle', 'bricks' ),
			'checkbox'                                    => __( 'Checkbox', 'bricks' ),
			'chooseFiles'                                 => __( 'Choose files', 'bricks' ),
			'chooseImage'                                 => __( 'Choose image', 'bricks' ),
			'class'                                       => __( 'Class', 'bricks' ),
			'classes'                                     => __( 'Classes', 'bricks' ),
			'className'                                   => __( 'Class name', 'bricks' ),
			'classNameExists'                             => __( 'Class name already exists', 'bricks' ),
			'classNamePlaceholder'                        => __( 'New class name', 'bricks' ),
			'clickToDownload'                             => __( 'Click to download', 'bricks' ),
			'classesDiscarded'                            => __( 'Classes discarded', 'bricks' ),
			'classesDuplicated'                           => __( 'Classes duplicated', 'bricks' ),
			'classesFound'                                => __( 'Classes found', 'bricks' ),
			'classesRenamed'                              => __( 'Classes renamed', 'bricks' ),
			'clauseName'                                  => __( 'Clause name', 'bricks' ),
			'clauseNameDesc'                              => __( 'Set clause name to be used as "Order by" parameter.', 'bricks' ),
			'clone'                                       => __( 'Clone', 'bricks' ),
			'cloned'                                      => __( 'cloned', 'bricks' ),
			'clean'                                       => __( 'Clean', 'bricks' ),
			'cleanUp'                                     => __( 'Clean up', 'bricks' ),
			'clear'                                       => __( 'Clear', 'bricks' ),
			'close'                                       => __( 'Close', 'bricks' ),
			'closestSide'                                 => __( 'Closest side', 'bricks' ),
			'closestCorner'                               => __( 'Closest corner', 'bricks' ),
			'closeEsc'                                    => __( 'Close (ESC)', 'bricks' ),
			'collapse'                                    => __( 'Collapse', 'bricks' ),
			'codeSignatures'                              => __( 'Code signatures', 'bricks' ),
			'codeSigned'                                  => __( 'Code signed', 'bricks' ),
			'codeSignaturesDescription'                   => __( 'Elements without code signature. Review, then sign your code one-by-one or all-at-once.', 'bricks' ),
			'color'                                       => __( 'Color', 'bricks' ),
			'colors'                                      => __( 'Colors', 'bricks' ),
			'colorStop'                                   => __( 'Color stop', 'bricks' ),
			'colorPalette'                                => __( 'Color palette', 'bricks' ),
			'colorPreview'                                => __( 'Color preview', 'bricks' ),
			'column'                                      => __( 'Column', 'bricks' ),
			'columns'                                     => __( 'Columns', 'bricks' ),
			'commandPalette'                              => __( 'Command palette', 'bricks' ),
			'commandPaletteInputPlaceholder'              => __( 'Enter a search term or command', 'bricks' ) . ' ...',
			'commandPaletteInputPlaceholderGoTo'          => __( 'Search or create post', 'bricks' ) . ' ...',
			'commandPaletteInputPlaceholderElements'      => '@section * 2 > @block > @heading + @button',
			'commandPaletteInputPlaceholderSave'          => __( 'Element structure name', 'bricks' ) . ' (' . __( 'Optional', 'bricks' ) . ')',
			'commandPaletteSelectPlaceholderElements'     => __( 'Select element structure', 'bricks' ),
			'commandPaletteMoreResults'                   => __( 'You are viewing the first 1000 results. Perform search to see more.', 'bricks' ),
			'commandPaletteInsertElementsInfo'            => __( 'Insert elements in Emmet-like syntax.', 'bricks' ) . ' ' . Helpers::article_link( 'command-palette/#elements', __( 'Learn more', 'bricks' ) ),
			'commonClasses'                               => __( 'Common classes', 'bricks' ),
			'community'                                   => __( 'Community', 'bricks' ),
			'communityTemplates'                          => __( 'Community templates', 'bricks' ),
			'compare'                                     => __( 'Compare', 'bricks' ),
			'component'                                   => __( 'Component', 'bricks' ),
			'components'                                  => __( 'Components', 'bricks' ),
			'componentNotFoundInfo'                       => __( 'Element can\'t be rendered as the connected component doesn\'t exist. Unlink this instance or import the missing component.', 'bricks' ),
			'condition'                                   => __( 'Condition', 'bricks' ),
			'conditions'                                  => __( 'Conditions', 'bricks' ),
			'conditionSelect'                             => __( 'Select condition', 'bricks' ),
			'conditionTiming'                             => __( 'Conditions always run before query loop.', 'bricks' ),
			'configure'                                   => __( 'Configure', 'bricks' ),
			'confirm'                                     => __( 'Confirm', 'bricks' ),
			'confirmDeleteIconSet'                        => __( 'Are you sure you want to delete this icon set?', 'bricks' ),
			'confirmDeletePermanently'                    => __( 'Permanently delete this icon? This action cannot be undone.', 'bricks' ),
			'confirmIconManageRemoveIcons'                => __( 'You are about to remove all selected icons from this set. Do you wish to proceed?', 'bricks' ),
			'confirmMoveToTrash'                          => __( 'Are you sure you want to move this font to the trash?', 'bricks' ),
			'conflict'                                    => __( 'Conflict', 'bricks' ),
			'conflicts'                                   => __( 'Conflicts', 'bricks' ),
			'conflictsDesc'                               => __( 'Resolve all conflicts listed below to save your changes.', 'bricks' ),
			'conflictsDesc2'                              => __( 'Click "Accept" to use the incoming database changes. Click "Discard" to save your current builder data instead.', 'bricks' ),
			'conic'                                       => __( 'Conic', 'bricks' ),
			'connect'                                     => __( 'Connect', 'bricks' ),
			'connectProperty'                             => __( 'Connect property', 'bricks' ),
			'connectedProperty'                           => __( 'Connected property', 'bricks' ),
			'contactUs'                                   => __( 'Contact us', 'bricks' ),
			'contain'                                     => __( 'Contain', 'bricks' ),
			'container'                                   => __( 'Container', 'bricks' ),
			'content'                                     => __( 'Content', 'bricks' ),
			'contenteditablePlaceholder'                  => __( 'Here goes my text ...', 'bricks' ),
			'contrast'                                    => __( 'Contrast', 'bricks' ),
			'controls'                                    => __( 'Controls', 'bricks' ),
			'convert'                                     => __( 'Convert', 'bricks' ),
			'copied'                                      => __( 'Copied', 'bricks' ),
			'copiedToClipboard'                           => __( 'Copied to clipboard', 'bricks' ),
			'copy'                                        => __( 'Copy', 'bricks' ),
			'copyToClipboard'                             => __( 'Copy to clipboard', 'bricks' ),
			'copyElementSelector'                         => __( 'Copy CSS selector', 'bricks' ),
			'cover'                                       => __( 'Cover', 'bricks' ),
			'current'                                     => __( 'Current', 'bricks' ),
			'currentPage'                                 => __( 'Current page', 'bricks' ),
			'currentPostAuthor'                           => __( 'Current post author', 'bricks' ),
			'currentPostTerm'                             => __( 'Current post term', 'bricks' ),
			'createComponent'                             => __( 'Create component', 'bricks' ),
			'createProperty'                              => __( 'Create property', 'bricks' ),
			'create'                                      => __( 'Create', 'bricks' ),
			'createIconSet'                               => __( 'Create icon set', 'bricks' ),
			'created'                                     => __( 'Created', 'bricks' ),
			'createTemplate'                              => __( 'Create template', 'bricks' ),
			'createTemplateTitlePlaceholder'              => __( 'Template title', 'bricks' ),
			'createTemplateTitle'                         => __( 'Create new template:', 'bricks' ),
			'createYourOwnElements'                       => __( 'Create your own elements', 'bricks' ),
			'crossSells'                                  => __( 'Cross-sells', 'bricks' ),
			'crossSellsQueryDescription'                  => __( 'Place this query on the product page.', 'bricks' ),
			'cssClass'                                    => __( 'CSS class', 'bricks' ),
			'cssClassName'                                => __( 'Class name', 'bricks' ),
			'cssClassesTooltip'                           => __( 'Separated by space. No leading dot "."', 'bricks' ),
			'cssIdTooltip'                                => __( 'No leading pound sign "#"', 'bricks' ),
			'cssFilter'                                   => __( 'CSS filter', 'bricks' ),
			'cssFilterDescription'                        => '<a target="_blank" href="https://developer.mozilla.org/en/docs/Web/CSS/filter?v=example">' . __( 'Enter CSS filters + value (learn more)', 'bricks' ) . '</a>',
			'cssSelector'                                 => __( 'CSS selector', 'bricks' ),
			'currentLayout'                               => __( 'Current layout', 'bricks' ),
			'currentVersionBy'                            => __( 'Current version by', 'bricks' ),
			'currentWidth'                                => __( 'Current width', 'bricks' ),
			'custom'                                      => __( 'Custom', 'bricks' ),
			'customIconSets'                              => __( 'Custom icon sets', 'bricks' ),
			'customCss'                                   => __( 'Custom CSS', 'bricks' ),
			'customFields'                                => __( 'Custom fields', 'bricks' ),
			'customFont'                                  => __( 'Custom font', 'bricks' ),
			'customUrl'                                   => __( 'Custom URL', 'bricks' ),

			'dashboard'                                   => __( 'Dashboard', 'bricks' ),
			'data'                                        => __( 'Data', 'bricks' ),
			'default'                                     => __( 'Default', 'bricks' ),
			// translators: %s: Default templates are disabled.
			'defaultTemplatesDisabled'                    => sprintf( __( '%s. Set template conditions or enable default templates.', 'bricks' ), '<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-templates' ) . '" target="_blank">' . __( 'Default templates are disabled', 'bricks' ) . '</a>' ),
			// translators: %s: Default templates are enabled.
			'defaultTemplatesEnabled'                     => sprintf( __( '%s. Template conditions precede default templates.', 'bricks' ), '<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-templates' ) . '" target="_blank">' . __( 'Default templates are enabled', 'bricks' ) . '</a>' ),
			// translators: %s: Default templates are disabled.
			'defaultTemplatesDisabled'                    => sprintf( __( '%s. Set template conditions or enable default templates.', 'bricks' ), '<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-templates' ) . '" target="_blank">' . __( 'Default templates are disabled', 'bricks' ) . '</a>' ),
			'dashed'                                      => __( 'dashed', 'bricks' ),
			'date'                                        => __( 'Date', 'bricks' ),
			'delay'                                       => __( 'Delay', 'bricks' ),
			'delete'                                      => __( 'Delete', 'bricks' ),
			'deleteIcon'                                  => __( 'Delete icon', 'bricks' ),
			'deleted'                                     => __( 'Deleted', 'bricks' ),
			'deleteAll'                                   => __( 'Delete all', 'bricks' ),
			'deleteComponentsInfo'                        => __( 'Export all components first by clicking the "Export" icon above before deleting any. Once exported, hover over the component you\'d like to delete, then click the "Delete" icon.', 'bricks' ),
			'deletePermanently'                           => __( 'Delete permanently', 'bricks' ),
			'deleteSelected'                              => __( 'Delete selected', 'bricks' ),
			'deprecated'                                  => __( 'Deprecated', 'bricks' ),
			'descending'                                  => __( 'Descending', 'bricks' ),
			'description'                                 => __( 'Description', 'bricks' ),
			'descriptionLightboxVideo'                    => __( 'YouTube, Vimeo or file URL.', 'bricks' ),
			'descriptionParallax'                         => __( 'Set to "Fixed" for parallax effect.', 'bricks' ),
			'deselect'                                    => __( 'Deselect', 'bricks' ),
			'desktop'                                     => __( 'Desktop', 'bricks' ),
			'details'                                     => __( 'Details', 'bricks' ),
			'direction'                                   => __( 'Direction', 'bricks' ),
			'disable'                                     => __( 'Disable', 'bricks' ),
			'disabled'                                    => __( 'Disabled', 'bricks' ),
			'disableUrlParamsFilter'                      => __( 'Disable URL parameter filter', 'bricks' ),
			'disableUrlParamsFilterDesc'                  => __( 'No URL parameters are generated or read, even if filter elements are present.', 'bricks' ),
			'disableQueryMerge'                           => __( 'Disable query merge', 'bricks' ),
			'discard'                                     => __( 'Discard', 'bricks' ),
			'disconnect'                                  => __( 'Disconnect', 'bricks' ),
			'discarded'                                   => __( 'Discarded', 'bricks' ),
			'div'                                         => 'Div',
			'documentation'                               => __( 'Documentation', 'bricks' ),
			'dots'                                        => __( 'Dots', 'bricks' ),
			'dotted'                                      => __( 'Dotted', 'bricks' ),
			'double'                                      => __( 'double', 'bricks' ),
			'download'                                    => __( 'Download', 'bricks' ),
			'downloaded'                                  => __( 'Downloaded', 'bricks' ),
			'downloading'                                 => __( 'Downloading', 'bricks' ),
			'dropFilesJSON'                               => __( 'Drop file(s) here', 'bricks' ) . ' (JSON)',
			'dropFilesFont'                               => __( 'Drop file(s) here', 'bricks' ) . ' (WOFF, WOFF2, TTF)',
			'duplicate'                                   => __( 'Duplicate', 'bricks' ),
			'duplicateClassesDetected'                    => __( 'Duplicate classes detected', 'bricks' ),
			'duplicateClassesWarning'                     => __( 'Duplicate classes detected. Resolve conflicts before importing.', 'bricks' ),
			'duplicateFontVariation'                      => __( 'A font variation with this weight and style already exists.', 'bricks' ),
			'dynamicData'                                 => __( 'Dynamic data', 'bricks' ),
			'dynamicDataIsEmpty'                          => __( 'Dynamic data is empty.', 'bricks' ),
			'dynamicDataTag'                              => __( 'Dynamic data tag', 'bricks' ),

			'edit'                                        => __( 'Edit', 'bricks' ),
			'editIcon'                                    => __( 'Edit icon', 'bricks' ),
			'edited'                                      => __( 'Edited', 'bricks' ),
			'editComponent'                               => __( 'Edit component', 'bricks' ),
			'editTemplate'                                => __( 'Edit Template', 'bricks' ),
			'editColorPalette'                            => __( 'Edit palette', 'bricks' ),
			'editing'                                     => __( 'Editing', 'bricks' ),
			'editInWordPress'                             => __( 'Edit in WordPress', 'bricks' ),
			'effect'                                      => __( 'Effect', 'bricks' ),
			'element'                                     => __( 'Element', 'bricks' ),
			'elements'                                    => __( 'Elements', 'bricks' ),
			'elementManager'                              => __( 'Element Manager', 'bricks' ),
			'elementClasses'                              => __( 'Element classes', 'bricks' ),
			'elementId'                                   => __( 'Element ID', 'bricks' ),
			'ellipse'                                     => __( 'Ellipse', 'bricks' ),
			'equal'                                       => __( 'Equal', 'bricks' ),

			// x-template element placeholder text
			'elementPlaceholder'                          => [
				'default'               => __( 'No content', 'bricks' ),

				'accordion'             => __( 'No accordion item added.', 'bricks' ),
				'audio'                 => __( 'No audio file selected.', 'bricks' ),
				'code'                  => __( 'No code found.', 'bricks' ),
				'countdown'             => __( 'No date/fields set.', 'bricks' ),
				'facebook'              => __( 'No Facebook page URL provided.', 'bricks' ),
				'form'                  => __( 'No form field added.', 'bricks' ),
				'html'                  => __( 'No HTML markup defined.', 'bricks' ),
				'icon'                  => __( 'No icon selected.', 'bricks' ),
				'list'                  => __( 'No list items defined.', 'bricks' ),
				'map'                   => sprintf(
					// translators: %s: Link to Bricks Academy
					__( 'Google Maps API key required! Add key in dashboard under: %s', 'bricks' ),
					'<a href="' . Helpers::settings_url( '#tab-api-keys' ) . '" target="_blank">Bricks > ' . __( 'Settings', 'bricks' ) . ' > API keys</a>'
				),
				'pricing-table'         => __( 'No pricing table defined.', 'bricks' ),
				'progress-bar'          => __( 'No progress bar created.', 'bricks' ),
				'slider'                => __( 'No slide added.', 'bricks' ),
				'social-icons'          => __( 'No icon selected.', 'bricks' ),
				'svg'                   => __( 'No SVG selected.', 'bricks' ),
				'tabs'                  => __( 'No tabs added.', 'bricks' ),
				'team-members'          => __( 'No team members added.', 'bricks' ),
				'template'              => __( 'No template selected.', 'bricks' ),
				'testimonials'          => __( 'No testimonials added.', 'bricks' ),
				'text'                  => __( 'No text added.', 'bricks' ),
				'videoNoFileUrl'        => __( 'No file URL provided.', 'bricks' ),
				'videoNoVideo'          => __( 'No video selected.', 'bricks' ),
				'videoNoYoutubeId'      => __( 'No YouTube URL provided.', 'bricks' ),
				'videoNoVimeoId'        => __( 'No Vimeo URL provided.', 'bricks' ),
				'videoNoDynamicData'    => __( 'No dynamic data set.', 'bricks' ),
				'videoDynamicDataEmpty' => __( 'The dynamic data is empty.', 'bricks' ),
			],

			'emailAddress'                                => __( 'Email address', 'bricks' ),
			'end'                                         => __( 'End', 'bricks' ),
			'endTime'                                     => __( 'End time', 'bricks' ),
			'error'                                       => __( 'Error', 'bricks' ),
			'errorBricksAcademy404'                       => __( 'Articles could not be loaded. Please visit the official knowledge base:', 'bricks' ),
			'errorPage'                                   => __( '404 Error Page', 'bricks' ),
			'errorCreatingClass'                          => __( 'Class found in trash', 'bricks' ),
			'errorDeletingClass'                          => __( 'Error deleting class', 'bricks' ),
			'errorDeletingClasses'                        => __( 'Error deleting class', 'bricks' ),
			'errorFetchingSiteClasses'                    => __( 'Error fetching site classes', 'bricks' ),
			'errorGeneratingCodeSignature'                => __( 'Code signatures are locked.', 'bricks' ),
			'errorRestoringClass'                         => __( 'Error restoring class', 'bricks' ),
			'errorOnSave'                                 => __( 'Error on save', 'bricks' ),
			'excerptLength'                               => __( 'Excerpt length', 'bricks' ),
			'exclude'                                     => __( 'Exclude', 'bricks' ),
			'excludeCurrent'                              => __( 'Exclude current post', 'bricks' ),
			'executeCode'                                 => __( 'Execute code', 'bricks' ),
			'expand'                                      => __( 'Expand', 'bricks' ),
			'expandAll'                                   => __( 'Expand all', 'bricks' ),
			'experimental'                                => __( 'experimental', 'bricks' ),
			'export'                                      => __( 'Export', 'bricks' ),
			'exportSelected'                              => __( 'Export selected', 'bricks' ),
			'exportVariables'                             => __( 'Export Variables', 'bricks' ),
			'extraLarge'                                  => __( 'Extra large', 'bricks' ),
			'extraSmall'                                  => __( 'Extra small', 'bricks' ),

			'fade'                                        => __( 'Fade', 'bricks' ),
			'farthestSide'                                => __( 'Farthest side', 'bricks' ),
			'farthestCorner'                              => __( 'Farthest corner', 'bricks' ),
			'fallbackFont'                                => __( 'Fallback fonts', 'bricks' ),
			'false'                                       => __( 'False', 'bricks' ),
			'favorites'                                   => __( 'Favorites', 'bricks' ),
			'featured'                                    => __( 'Featured', 'bricks' ),
			'field'                                       => __( 'Field', 'bricks' ),
			'file'                                        => __( 'File', 'bricks' ),
			'fileImported'                                => __( '"%s" imported.', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
			'fileNotImportedAlreadyExists'                => __( 'Import of "%s" failed: Name already exists.', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
			'fileNotImportedWrongFormat'                  => __( 'Import of "%s" failed: Wrong format.', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
			'fileUrl'                                     => __( 'File URL', 'bricks' ),
			'files'                                       => __( 'Files', 'bricks' ),
			'fill'                                        => __( 'Fill', 'bricks' ),
			'fillGrid'                                    => __( 'Fill grid', 'bricks' ),
			'filter'                                      => __( 'Filter', 'bricks' ),
			'fillDark'                                    => __( 'Fill - Dark', 'bricks' ),
			'fillLight'                                   => __( 'Fill - Light', 'bricks' ),
			'fillPrimary'                                 => __( 'Fill - Primary', 'bricks' ),
			'find'                                        => __( 'Find', 'bricks' ),
			'finish'                                      => __( 'Finish', 'bricks' ),
			'fixed'                                       => __( 'Fixed', 'bricks' ),
			'fontDeletedPermanentlyConfirm'               => __( 'Are you sure you want to delete this font and all of its font variation files?', 'bricks' ),
			'fontDeletedPermanently'                      => __( 'Font deleted permanently', 'bricks' ),
			'fontFamily'                                  => __( 'Font family', 'bricks' ),
			'fontFamilyPlaceholder'                       => __( 'Font name', 'bricks' ),
			'fontFileSelected'                            => __( 'Font file selected', 'bricks' ),
			'fontDownloaded'                              => __( 'Font downloaded', 'bricks' ) . ' (' . __( 'Custom fonts', 'bricks' ) . ')',
			'fontDownloadFailed'                          => __( 'Font download failed', 'bricks' ),
			'fontManager'                                 => __( 'Font manager', 'bricks' ),
			'fontPreviewTextCustom'                       => __( 'Custom preview text', 'bricks' ),
			'fontRestored'                                => __( 'Font restored', 'bricks' ),
			'fontRestoreError'                            => __( 'Font restore error', 'bricks' ),
			'fontSize'                                    => __( 'Font size', 'bricks' ),
			'fontStyle'                                   => __( 'Font style', 'bricks' ),
			'fontWeight'                                  => __( 'Font weight', 'bricks' ),
			// translators: %s: Link to Bricks settings
			'fontFavoritesDescription'                    => sprintf(
				__( 'By default, the favorite fonts are listed first in the font-family options. To show only the favorite fonts, select "Show favorites only" at %s.', 'bricks' ),
				'<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-builder' ) . '" target="_blank">Bricks > ' . __( 'Settings', 'bricks' ) . ' > ' . __( 'Builder', 'bricks' ) . ' > ' . __( 'Font Family', 'bricks' ) . ': ' . __( 'Options', 'bricks' ) . '</a>'
			),
			'fontMovedToTrash'                            => __( 'Font moved to trash', 'bricks' ),
			'fontVariants'                                => __( 'Font variants', 'bricks' ),
			'fontVariations'                              => __( 'Font variations', 'bricks' ),
			'fontVariationNoFile'                         => __( 'Select/upload font variation', 'bricks' ),
			'fontVariationSettings'                       => __( 'Font variation settings', 'bricks' ),
			'fonts'                                       => __( 'Fonts', 'bricks' ),
			'fontsAdobe'                                  => __( 'Adobe fonts', 'bricks' ),
			'fontsCustom'                                 => __( 'Custom fonts', 'bricks' ),
			'fontsGoogle'                                 => __( 'Google fonts', 'bricks' ),
			'fontsStandard'                               => __( 'Standard fonts', 'bricks' ),
			'footer'                                      => __( 'Footer', 'bricks' ),
			'frontend'                                    => __( 'Frontend', 'bricks' ),
			'fullSize'                                    => __( 'Full size', 'bricks' ),
			'fullScreen'                                  => __( 'Fullscreen', 'bricks' ),

			'galleryLayout'                               => __( 'Gallery layout', 'bricks' ),
			'gap'                                         => __( 'Gap', 'bricks' ),
			'general'                                     => __( 'General', 'bricks' ),
			'generateScreenshots'                         => __( 'Generate screenshots', 'bricks' ),
			'generatingScreenshots'                       => __( 'Generating screenshots' ),
			'ghostDark'                                   => __( 'Outline - Dark', 'bricks' ),
			'ghostLight'                                  => __( 'Outline - Light', 'bricks' ),
			'ghostPrimary'                                => __( 'Outline - Primary', 'bricks' ),
			'global'                                      => __( 'Global', 'bricks' ),
			'globalElement'                               => __( 'Global element', 'bricks' ),
			'globalElements'                              => __( 'Global elements', 'bricks' ),
			'globalElementDeprecatedInfo'                 => sprintf(
				__( 'Global elements are deprecated since version 2.0 and will be removed in the near future. Please convert them into components as soon as possible under %s. Once done, please delete all global elements by hovering over a global element below and clicking the "Delete" icon.', 'bricks' ),
				'<a href="' . admin_url( 'admin.php?page=bricks-settings' ) . '" target="_blank">Bricks > ' . __( 'Settings', 'bricks' ) . ' > ' . __( 'General', 'bricks' ) . ' > ' . __( 'Convert', 'bricks' ) . '</a>'
			),
			'globalClass'                                 => __( 'Global class', 'bricks' ),
			'globalClasses'                               => __( 'Global classes', 'bricks' ),
			'globalClassManagerImportSettings'            => '<a href="' . admin_url( 'admin.php?page=bricks-settings#tab-builder' ) . '" target="_blank">Bricks > ' . __( 'Settings', 'bricks' ) . ' > ' . __( 'Builder', 'bricks' ) . ' > ' . __( 'Global class import manager', 'bricks' ) . '</a>',
			'globalClassManagerInfoBulk'                  => __( 'Press CMD/CTRL or SHIFT to select and edit multiple categories or classes.', 'bricks' ),
			'globalClassManagerInfoCategory'              => __( 'Select one or multiple categories to filter your classes by them.', 'bricks' ),
			'globalClassManagerInfoCategorize'            => __( 'Categorize classes by dragging them into a specific category or into "Uncategorize" to uncategorize them.', 'bricks' ),
			'globalClassManagerInfoImport'                => __( 'Once you have reviewed all classes and resolved all conflicts, click the "Import" button at the top to import the classes into your site.', 'bricks' ),
			'globalClassManagerInfoClass'                 => __( 'Select one or multiple classes to edit them.', 'bricks' ),
			'globalClassManagerInfoOrder'                 => __( 'Drag any category or class up/down to order it.', 'bricks' ),
			'globalClassManagerInfoTitle'                 => __( 'How to use the global class manager', 'bricks' ),
			'globalClassManagerImportInfoTitle'           => __( 'How to use the class importer', 'bricks' ),
			'globalClassManagerSearchInfo'                => __( 'Prefix with a dot to search for classes starting with the string, or suffix with a dot to search for classes ending with the string.', 'bricks' ),
			'globalClassManagerImportSearchInfo'          => __( 'Prefix with a dot to search for imported classes starting with the string, or suffix with a dot to search for imported classes ending with the string.', 'bricks' ),
			'globalClassesImported'                       => __( 'Global classes imported', 'bricks' ),
			'globalClassesEmptyDescription'               => __( 'Enter the name of your first global CSS class in the field above. Then hit enter to create it.', 'bricks' ) . ' (' . Helpers::article_link( 'global-css-classes', __( 'Learn more', 'bricks' ) ) . ')',
			'globalVariableManagerImportTextarea'         => __( 'Enter CSS variable definitions separated by semicolon', 'bricks' ),
			'globalVariableManagerInfoTitle'              => __( 'How to use the global variable manager', 'bricks' ),
			'globalVariableManagerColorEditTitle'         => __( 'Color editor', 'bricks' ),
			'globalVariableManagerInfoCategory'           => __( 'Select one or multiple categories to filter your variables by them.', 'bricks' ),
			'globalVariableManagerInfoVariable'           => __( 'Select one or multiple variables to edit them.', 'bricks' ),
			'globalVariableManagerInfoBulk'               => __( 'Press CMD/CTRL or SHIFT to select and edit multiple categories or variables.', 'bricks' ),
			'globalVariableManagerInfoOrder'              => __( 'Drag any category or variable up/down to order it.', 'bricks' ),
			'globalVariableManagerInfoCategorize'         => __( 'Categorize variables by dragging them into a specific category or into "Uncategorize" to uncategorize them.', 'bricks' ),
			'globalVariableManagerNothingFound'           => __( 'No variables found. Create a CSS variable using the input at the bottom or in bulk by clicking the "Import" icon at the top.', 'bricks' ),
			'globalVariableManagerSearchInfo'             => __( 'Prefix with a dot to search for variables starting with the string, or suffix with a dot to search for variables ending with the string.', 'bricks' ),
			'googleFontsDisabled'                         => __( 'Google fonts have been disabled', 'bricks' ) . ': Bricks > ' . __( 'Settings', 'bricks' ) . ' > ' . __( 'Performance', 'bricks' ),
			'gradient'                                    => __( 'Gradient', 'bricks' ),
			// translators: %s: Color stop, %s: Colors
			'gradientRepeatInfo'                          => sprintf(
				__( 'Make sure to set "%1$s" in your "%2$s" definitions below.', 'bricks' ),
				__( 'Color stop', 'bricks' ),
				__( 'Colors', 'bricks' )
			),
			'groups'                                      => __( 'Groups', 'bricks' ),
			'group'                                       => __( 'Group', 'bricks' ),
			'groupAlreadyExists'                          => __( 'Group already exists', 'bricks' ),
			'gardientColorsDescription'                   => __( 'Add at least two colors to create a gradient.', 'bricks' ),
			'goToSettingsPanel'                           => __( 'Back to settings', 'bricks' ),
			'gotIt'                                       => __( 'Got it', 'bricks' ),
			'goTo'                                        => __( 'Go to', 'bricks' ),
			'grid'                                        => __( 'Grid', 'bricks' ),
			'gridItem'                                    => __( 'Grid item', 'bricks' ),
			'gutter'                                      => __( 'Spacing', 'bricks' ),

			'hasConflict'                                 => __( 'Has conflict', 'bricks' ),
			'hasInheritedSettings'                        => __( 'Has inherited settings', 'bricks' ),
			'hasStyles'                                   => __( 'Has styles', 'bricks' ),
			'hasNoStyles'                                 => __( 'Has no styles', 'bricks' ),
			'header'                                      => __( 'Header', 'bricks' ),
			'height'                                      => __( 'Height', 'bricks' ),
			'help'                                        => __( 'Help', 'bricks' ),
			'hide'                                        => __( 'Hide', 'bricks' ),
			'hideElement'                                 => __( 'Hide element', 'bricks' ),
			'hideElementBuilderDesc'                      => __( 'Enable to not load/render this element in the builder.', 'bricks' ),
			'hideElementFrontendDesc'                     => __( 'Enable to not load/render this element on the frontend.', 'bricks' ),
			'hidden'                                      => __( 'Hidden', 'bricks' ),
			'hideInfo'                                    => __( 'Hide info', 'bricks' ),
			'hideOutOfStock'                              => __( 'Hide out of stock', 'bricks' ),
			'history'                                     => __( 'History', 'bricks' ),
			'historyDeleted'                              => __( 'History deleted', 'bricks' ),
			'home'                                        => __( 'Home', 'bricks' ),
			'homePage'                                    => __( 'Home page', 'bricks' ),
			'horizontal'                                  => __( 'Horizontal', 'bricks' ),
			'howToCreateHeaderTemplate'                   => __( 'How to create a header template', 'bricks' ),
			'howToCreateFooterTemplate'                   => __( 'How to create a footer template', 'bricks' ),
			'html5AudioNoBrowserSupport'                  => __( 'Your browser does not support the audio tag.', 'bricks' ),
			'html5VideoNoBrowserSupport'                  => __( 'Your browser does not support the video tag.', 'bricks' ),
			'hue'                                         => __( 'Hue', 'bricks' ),

			'icon'                                        => __( 'Icon', 'bricks' ),
			'icons'                                       => __( 'Icons', 'bricks' ),
			'iconManager'                                 => __( 'Icon manager', 'bricks' ),
			'iconSet'                                     => __( 'Icon set', 'bricks' ),
			'iconsDeleted'                                => __( 'Icon(s) deleted successfully', 'bricks' ),
			'iconSetDisabledInfo'                         => __( 'This icon set is currently disabled and hidden from the icon dropdown menu. However, any existing icons from this set will still display on your site.', 'bricks' ),
			'iconSource'                                  => __( 'Icon source', 'bricks' ),
			'iconRemoveConfirmation'                      => __( 'Are you sure you want to remove this icon?', 'bricks' ),
			'iconsImported'                               => __( 'Icon(s) imported successfully', 'bricks' ),
			'ignoreStickyPosts'                           => __( 'Ignore sticky posts', 'bricks' ),
			'image'                                       => __( 'Image', 'bricks' ),
			'imageGallery'                                => __( 'Image gallery', 'bricks' ),
			'imageGalleryDescription'                     => __( 'Hold down CMD/CRTL to select multiple images.', 'bricks' ),
			'imageNotFound'                               => __( 'Image not found', 'bricks' ),
			'imageSize'                                   => __( 'Image size', 'bricks' ),
			'import'                                      => __( 'Import', 'bricks' ),
			'imported'                                    => __( 'Imported', 'bricks' ),
			'importClasses'                               => __( 'Import classes', 'bricks' ),
			'importClassesSkip'                           => __( 'Skip class import', 'bricks' ),
			'importClassesInfo'                           => __( 'New classes detected. Resolve conflicts, if any, to import or skip.', 'bricks' ),
			'importClassConflictById'                     => __( 'A class with the same internal ID, but different settings, already exists on this site. You must either override the existing class on your site or discard this imported version.', 'bricks' ),
			'importClassConflictByName'                   => __( 'A class with the same name, but different settings, already exists on this site. You must either override the existing class on your site or discard this imported version.', 'bricks' ),
			'importClassesConflict'                       => __( 'One or more of the selected classes conflict with existing classes on your site. You must either override the existing classes on your site or discard these imported versions.', 'bricks' ),
			'importClassesResolveConflicts'               => __( 'Resolve all conflicts listed below, highlighted in red, to continue with importing those classes.', 'bricks' ),
			'importCssVariables'                          => __( 'Import CSS variables', 'bricks' ),
			'importImages'                                => __( 'Import images', 'bricks' ),
			'importImagesDisabled'                        => __( 'Disabled: Show placeholder images.', 'bricks' ),
			'importImagesEnabled'                         => __( 'Enabled: Download template images to media library.', 'bricks' ),
			'imports'                                     => __( 'Imports', 'bricks' ),
			'importTemplateDragAndDrop'                   => __( 'Drag and drop .JSON or .ZIP template file(s) in here ..', 'bricks' ),
			'importTemplate'                              => __( 'Import template', 'bricks' ),
			'importNote'                                  => __( 'Valid JSON data required to run the importer', 'bricks' ),
			'importTemplateColorPalette'                  => __( 'This template contains a color palette. Would you like to import it?', 'bricks' ),
			'importTemplateColorPalettes'                 => __( 'This template contains color palettes. Would you like to import them?', 'bricks' ),
			'importTemplateGlobalVariables'               => __( 'This template contains global variables. Would you like to import them?', 'bricks' ),
			'importTemplateThemeStyles'                   => __( 'This template contains the following theme styles. Would you like to import them?', 'bricks' ),
			'include'                                     => __( 'Include', 'bricks' ),
			'includeChildren'                             => __( 'Include children', 'bricks' ),
			'incoming'                                    => __( 'Incoming', 'bricks' ),
			'incomingChanges'                             => __( 'Incoming changes', 'bricks' ),
			'index'                                       => __( 'Index', 'bricks' ),
			'infinite'                                    => __( 'Infinite', 'bricks' ),
			'infiniteScroll'                              => __( 'Infinite scroll', 'bricks' ),
			'info'                                        => __( 'Info', 'bricks' ),
			'infoElementDisabled'                         => __( 'Element has been disabled globally.', 'bricks' ),
			'infoElementNotFound'                         => __( 'Element doesn\'t exist.', 'bricks' ),
			'infoLightbox'                                => __( 'Customize lightbox: Settings > Theme Styles > General', 'bricks' ),
			'infoAccessRequired'                          => __( 'Your builder capability doesn\'t allow you to access these settings.', 'bricks' ),
			'inheritedFrom'                               => __( 'Inherited from', 'bricks' ),
			'innerContainer'                              => __( 'Inner container', 'bricks' ),
			'insert'                                      => __( 'Insert', 'bricks' ),
			'inserted'                                    => __( 'Inserted', 'bricks' ),
			'insertAfter'                                 => __( 'Insert after', 'bricks' ),
			'insertMedia'                                 => __( 'Insert media', 'bricks' ),
			'insertLayout'                                => __( 'Insert layout', 'bricks' ),
			'insertSection'                               => __( 'Insert section', 'bricks' ),
			'insertTemplate'                              => __( 'Insert template', 'bricks' ),
			'insertSameComponentError'                    => __( 'Insert of the same component is not possible.', 'bricks' ),
			'inset'                                       => __( 'Inset', 'bricks' ),
			'instance'                                    => __( 'Instance', 'bricks' ),
			'instances'                                   => __( 'Instances', 'bricks' ),
			'interactionId'                               => __( 'Interaction ID', 'bricks' ),
			'interactions'                                => __( 'Interactions', 'bricks' ),
			'internal'                                    => __( 'Internal post/page', 'bricks' ),
			'invalidSvgFiles'                             => __( 'Invalid SVG files', 'bricks' ),
			'invert'                                      => __( 'Invert', 'bricks' ),
			'isArchiveMainQuery'                          => __( 'Is main query', 'bricks' ),
			'isArchiveMainQueryDescription'               => __( 'Enable if your archive pagination is not working.', 'bricks' ),
			'italic'                                      => __( 'Italic', 'bricks' ),
			'item'                                        => __( 'Item', 'bricks' ),

			'joinUs'                                      => __( 'Join Us', 'bricks' ),
			'justify'                                     => __( 'Justify', 'bricks' ),
			'justifyContent'                              => __( 'Justify content', 'bricks' ),

			'key'                                         => __( 'Key', 'bricks' ),
			'keyboardShortcuts'                           => __( 'Keyboard shortcuts', 'bricks' ),

			'label'                                       => __( 'Label', 'bricks' ),
			'language'                                    => __( 'Language', 'bricks' ),
			'large'                                       => __( 'Large', 'bricks' ),
			'laptop'                                      => __( 'Laptop', 'bricks' ),
			'lastRefresh'                                 => __( 'Last refresh', 'bricks' ),
			'latest'                                      => __( 'Latest', 'bricks' ),
			'layout'                                      => __( 'Layout', 'bricks' ),
			'learnMore'                                   => __( 'Learn more', 'bricks' ),
			'left'                                        => __( 'Left', 'bricks' ),
			'letterSpacing'                               => __( 'Letter spacing', 'bricks' ),
			'lightboxAnimation'                           => __( 'Lightbox', 'bricks' ) . ': ' . __( 'Animation', 'bricks' ),
			'lightboxId'                                  => __( 'Lightbox ID', 'bricks' ),
			'lightboxImage'                               => __( 'Lightbox Image', 'bricks' ),
			'lightboxVideo'                               => __( 'Lightbox Video', 'bricks' ),
			'lightness'                                   => __( 'Lightness', 'bricks' ),
			'lineHeight'                                  => __( 'Line height', 'bricks' ),
			'link'                                        => __( 'Link', 'bricks' ),
			'linear'                                      => __( 'Linear', 'bricks' ),
			'linked'                                      => __( 'Linked', 'bricks' ),
			'list'                                        => __( 'List', 'bricks' ),
			'liveSearch'                                  => __( 'Live search', 'bricks' ),
			'liveSearchDescription'                       => __( 'When enabled, this query only runs when a live search is performed.', 'bricks' ),
			'liveSearchInfo'                              => __( 'Provide the element ID that holds the live search results below.', 'bricks' ),
			'liveSearchWrapperSelector'                   => __( 'Live search results', 'bricks' ),
			'liveSearchWrapperSelectorDesc'               => __( 'Element ID that holds the live search results. Only visible when the live search is performed.', 'bricks' ),
			'loadingTemplates'                            => __( 'Loading templates', 'bricks' ),
			'loadingFontData'                             => __( 'Loading font data', 'bricks' ),
			'loadMore'                                    => __( 'Load more', 'bricks' ),
			'lock'                                        => __( 'Lock', 'bricks' ),
			'lockSelected'                                => __( 'Lock selected', 'bricks' ),
			'locked'                                      => __( 'Locked', 'bricks' ),
			'lockedUserGoBack'                            => __( 'Go back', 'bricks' ),
			'lockedUserTakeOver'                          => __( 'Take over', 'bricks' ),
			'lockedUserTitle'                             => __( 'This post is already being edited.', 'bricks' ),
			'lockedUserText'                              => __( '%s is currently working on this post, which means you cannot make changes, unless you take over.', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
			'login'                                       => __( 'Login', 'bricks' ),
			'loop'                                        => __( 'Loop', 'bricks' ),
			'lowercase'                                   => __( 'Lowercase', 'bricks' ),

			'linkStates'                                  => [
				'unlinked'  => __( 'Unlinked', 'bricks' ),
				'opposites' => __( 'Opposites linked', 'bricks' ),
				'all'       => __( 'All sides linked', 'bricks' ),
			],

			'main'                                        => __( 'Main', 'bricks' ),
			'mainQuery'                                   => __( 'Main query', 'bricks' ),
			'manage'                                      => __( 'Manage', 'bricks' ),
			'margin'                                      => __( 'Margin', 'bricks' ),
			'markAllAsRead'                               => __( 'Mark all as read', 'bricks' ),
			'masonry'                                     => 'Masonry',

			// translators: %s: Max upload size
			'maxUploadSizeInfo'                           => sprintf( __( 'Max upload size: %s', 'bricks' ), size_format( wp_max_upload_size() ) ),
			'media'                                       => __( 'Media', 'bricks' ),
			'metaKey'                                     => __( 'Meta key', 'bricks' ),
			'metaKeyOrder'                                => __( 'Order meta key', 'bricks' ),
			'metaValue'                                   => __( 'Meta value', 'bricks' ),
			'metaValueNum'                                => __( 'Numeric meta value', 'bricks' ),
			'metaQuery'                                   => __( 'Meta query', 'bricks' ),
			'menuOrder'                                   => __( 'Menu order', 'bricks' ),
			'metro'                                       => 'Metro',
			'mimeType'                                    => __( 'Mime type', 'bricks' ),
			'mimeTypeDesc'                                => Helpers::article_link( 'query-loop/#media-query', __( 'Filter media by mime type', 'bricks' ) ),
			'mobile'                                      => __( 'Mobile', 'bricks' ),
			'mobileFirst'                                 => __( 'Mobile first', 'bricks' ),
			'mode'                                        => __( 'Mode', 'bricks' ),
			'modified'                                    => __( 'Modified', 'bricks' ),
			'modifiedDate'                                => __( 'Modified date', 'bricks' ),
			'months'                                      => [
				__( 'January', 'bricks' ),
				__( 'February', 'bricks' ),
				__( 'March', 'bricks' ),
				__( 'April', 'bricks' ),
				__( 'May', 'bricks' ),
				__( 'June', 'bricks' ),
				__( 'July', 'bricks' ),
				__( 'August', 'bricks' ),
				__( 'September', 'bricks' ),
				__( 'October', 'bricks' ),
				__( 'November', 'bricks' ),
				__( 'December', 'bricks' ),
			],
			'moreLayouts'                                 => __( 'More layouts', 'bricks' ),
			'mostPopular'                                 => __( 'Most Popular', 'bricks' ),
			'move'                                        => __( 'Move', 'bricks' ),
			'moveSelected'                                => __( 'Move selected', 'bricks' ),
			'moved'                                       => __( 'Moved', 'bricks' ),
			'moveToTrash'                                 => __( 'Move to trash', 'bricks' ),
			'movedToTrash'                                => __( 'Moved to trash', 'bricks' ),
			'multipleOptions'                             => __( 'Multiple options', 'bricks' ),
			'myTemplates'                                 => __( 'My templates', 'bricks' ),
			'myAccount'                                   => __( 'My account', 'bricks' ),

			'name'                                        => __( 'Name', 'bricks' ),
			'new'                                         => __( 'New', 'bricks' ),
			'newColorPalette'                             => __( 'New color palette name', 'bricks' ),
			'newColorPaletteCreateFirstColor'             => __( 'Add your first color to this palette by selecting a color value above and then click "Save".', 'bricks' ),
			'newGroupName'                                => __( 'New group name', 'bricks' ),
			'newTab'                                      => __( 'New tab', 'bricks' ),
			'newImageName'                                => __( 'Type name, hit enter', 'bricks' ),
			'next'                                        => __( 'Next', 'bricks' ),
			'noActiveSet'                                 => __( 'No active icon set selected', 'bricks' ),
			'noClassesToImport'                           => __( 'No classes to import.', 'bricks' ),
			'noComponentsFound'                           => __( 'No components found.', 'bricks' ),
			'noConditionsSet'                             => __( 'Click the "+" icon to add your first condition.', 'bricks' ) . ' <strong>' . __( 'Conditions don\'t run in the builder.', 'bricks' ) . '</strong>',
			'noInteractionsSet'                           => __( 'Click the "+" icon to add your first interaction.', 'bricks' ) . ' <strong>' . __( 'Interactions don\'t run in the builder.', 'bricks' ) . '</strong>',
			'noContent'                                   => __( 'No content', 'bricks' ),
			'noFileSelected'                              => __( 'No file selected.', 'bricks' ),
			'noInstances'                                 => __( 'No instances', 'bricks' ),
			'noPropertiesConnected'                       => __( 'No properties connected.', 'bricks' ),
			'noConnectablePropertyFound'                  => __( 'No connectable property found.', 'bricks' ),
			'noPropertiesConnectedDesc'                   => __( 'Properties found, but none are conneted to any setting of your main component.', 'bricks' ),
			'noPropertiesDesc'                            => __( 'Create properties and connect them to your component settings to customize a component instance.', 'bricks' ),
			'noPropertiesFound'                           => __( 'No properties found.', 'bricks' ),
			'noPropertyGroupsFound'                       => __( 'No property groups found.', 'bricks' ),
			'no'                                          => __( 'No', 'bricks' ),
			'noConflict'                                  => __( 'No conflict', 'bricks' ),
			'noDefaultValue'                              => __( 'No default value', 'bricks' ),
			'none'                                        => __( 'None', 'bricks' ),
			'noRepeat'                                    => __( 'No-repeat', 'bricks' ),
			'noResults'                                   => __( 'No results', 'bricks' ),
			'noResultsDescription'                        => __( 'Select a template or provide a custom text to show if this query doesn\'t return any results.', 'bricks' ),
			'noPermission'                                => __( 'No permission', 'bricks' ),
			'normal'                                      => __( 'Normal', 'bricks' ),
			'noVariablesFound'                            => __( 'No CSS variable found.', 'bricks' ),
			'noDynamicDataFound'                          => __( 'No dynamic data found.', 'bricks' ),
			'noTemplatesFound'                            => __( 'No templates found.', 'bricks' ),
			'notFound'                                    => __( 'Not found', 'bricks' ),
			'nothingFound'                                => __( 'Nothing found.', 'bricks' ),
			'nothingFoundKeyword'                         => __( 'Nothing found. Please try again with a different keyword!', 'bricks' ),
			'nothingToCopy'                               => __( 'Nothing to copy', 'bricks' ),
			'nothingToPaste'                              => __( 'Nothing to paste', 'bricks' ),
			'notifications'                               => [
				'title'           => __( 'Notifications', 'bricks' ),
				'autosave'        => [
					'button'      => __( 'Preview autosave', 'bricks' ),
					'description' => __( 'There is an autosave more recent than the version you are currently viewing.', 'bricks' ),
				],
				'svg'             => [
					'description' => __( 'SVG files not imported for security reasons.', 'bricks' ),
				],
				'templateBundle'  => [
					'button'      => __( 'Set template style', 'bricks' ),
					'description' => __( 'Inserted template uses theme style "%s"', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
				],
				'populateContent' => [
					'button'      => __( 'Change content', 'bricks' ),
					'description' => __( 'Currently previewing content from "%s".', 'bricks' ), // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment
				]
			],
			'number'                                      => __( 'Number', 'bricks' ),
			'numberedlist'                                => __( 'Numbered list', 'bricks' ),

			'offset'                                      => __( 'Offset', 'bricks' ),
			'onSale'                                      => __( 'On sale', 'bricks' ),
			'opacity'                                     => __( 'Opacity', 'bricks' ),
			'open'                                        => __( 'Open', 'bricks' ),
			'openInNewTab'                                => __( 'Open in new tab', 'bricks' ),
			'openIconManager'                             => __( 'Open icon manager', 'bricks' ),
			'optional'                                    => __( 'Optional', 'bricks' ),
			'option'                                      => __( 'Option', 'bricks' ),
			'options'                                     => __( 'Options', 'bricks' ),
			'or'                                          => __( 'Or', 'bricks' ),
			'order'                                       => __( 'Order', 'bricks' ),
			'orderBy'                                     => __( 'Order by', 'bricks' ),
			// translators: %s: Number of orphaned elements
			'orphanedElementsDetected'                    => __( 'Orphaned elements detected (%s). Please back-up your site or at least copy all elements in the structure panel, then click the "Clean up" button below to remove all orphaned elements.', 'bricks' ) . ' ' . Helpers::article_link( 'known-issues/#orphaned-elements', __( 'Learn more', 'bricks' ) ),
			'orphanedElementsRemoved'                     => __( 'Orphaned elements removed.', 'bricks' ),
			'otherClasses'                                => __( 'Other classes', 'bricks' ),
			'otherPages'                                  => __( 'Other pages', 'bricks' ),
			'otherStyles'                                 => __( 'Other styles', 'bricks' ),
			'overlay'                                     => __( 'Overlay', 'bricks' ),
			'overline'                                    => __( 'Overline', 'bricks' ),
			'override'                                    => __( 'Override', 'bricks' ),
			'overrideLocalClass'                          => __( 'Override local class', 'bricks' ),
			'overwrite'                                   => __( 'Overwrite', 'bricks' ),

			'padding'                                     => __( 'Padding', 'bricks' ),
			'page'                                        => __( 'Page', 'bricks' ),
			'pages'                                       => __( 'Pages', 'bricks' ),
			'pageSettings'                                => __( 'Page settings', 'bricks' ),
			'panelRevisionsInfo'                          => __( 'Select any revision to preview it. Click "Apply" to continue editing the selected revision. Click "Discard" to continue editing the current revision.', 'bricks' ),
			'parent'                                      => __( 'Parent', 'bricks' ),
			'postParentId'                                => __( 'Insert post parent ID', 'bricks' ),
			'paste'                                       => __( 'Paste', 'bricks' ),
			'pasted'                                      => __( 'Pasted', 'bricks' ),
			'paused'                                      => __( 'Paused', 'bricks' ),
			'pin'                                         => __( 'Pin', 'bricks' ),
			'pinned'                                      => __( 'Pinned', 'bricks' ),
			'pinnedElements'                              => __( 'Pinned elements', 'bricks' ),
			'placeholder'                                 => __( 'Placeholder', 'bricks' ),
			'placeholderEmptyCanvas'                      => __( 'Click on any element to add it to your canvas.', 'bricks' ),
			'placeholderEmptyPopup'                       => __( 'Click on any element to add it to your popup.', 'bricks' ),
			'placeholderFormMessage'                      => __( 'Your message goes here. The more details, the better ;)', 'bricks' ),
			'placeholderImageInfo'                        => Helpers::article_link( 'filter-bricks-placeholder_image/', __( 'Placeholder image shown.', 'bricks' ) ),
			'placeholderTemplateName'                     => __( 'Enter new template name', 'bricks' ),
			'placeholderSearchDocumentation'              => __( 'Search documentation', 'bricks' ),
			'placeholderSelectPost'                       => __( 'Select post/page', 'bricks' ),
			'placeholderSelectLinkType'                   => __( 'Select link type', 'bricks' ),
			'placeholderYourName'                         => __( 'Your name (optional)', 'bricks' ),
			'playInteraction'                             => __( 'Play interaction', 'bricks' ),
			'playOnce'                                    => __( 'Play once', 'bricks' ),
			'popular'                                     => __( 'Popular', 'bricks' ),
			'popup'                                       => __( 'Popup', 'bricks' ),
			'position'                                    => __( 'Position', 'bricks' ),
			'post'                                        => __( 'Post', 'bricks' ),
			'posts'                                       => __( 'Posts', 'bricks' ),
			'postsOffsetDescription'                      => __( 'Ignored when posts per page set to "-1".', 'bricks' ),
			'postsPerPage'                                => __( 'Posts per page', 'bricks' ),
			'postType'                                    => __( 'Post type', 'bricks' ),
			'postTypes'                                   => __( 'Post types', 'bricks' ),
			// translators: %s: Link to Unsplash
			'poweredByUnsplash'                           => sprintf( __( 'Powered by %s', 'bricks' ), '<a href="https://unsplash.com/?ref=bricksbuilderio" target="_blank">Unsplash</a>' ),
			'prev'                                        => __( 'Prev', 'bricks' ),
			'preview'                                     => __( 'Preview', 'bricks' ),
			'prefix'                                      => __( 'Prefix', 'bricks' ),
			'previewMode'                                 => __( 'Preview mode', 'bricks' ),
			'previewTemplate'                             => __( 'Preview template', 'bricks' ),
			'property'                                    => __( 'Property', 'bricks' ),
			'propertyDefaultSelectControlInfo'            => __( 'To select a default value you have to first connect this property with the select control.', 'bricks' ),
			'propertyGroups'                              => __( 'Property groups', 'bricks' ),
			'propertyGroupsDesc'                          => __( 'Organize your properties in groups. Reorder your groups via drag & drop. Click to rename. Create a property group using the form below.', 'bricks' ),
			'propertyOptionsDesc'                         => __( 'Leave options empty to use the options of the first connected control.', 'bricks' ),
			'properties'                                  => __( 'Properties', 'bricks' ),
			'pseudoClass'                                 => __( 'Pseudo class', 'bricks' ),
			'pseudoClassError'                            => __( 'Invalid pseudo class. Must start with a colon (:)', 'bricks' ),
			'pseudos'                                     => __( 'Pseudos', 'bricks' ),
			'publish'                                     => __( 'Publish', 'bricks' ),
			'published'                                   => __( 'Published', 'bricks' ),

			'query'                                       => __( 'Query', 'bricks' ),
			'queryEditor'                                 => __( 'Query editor', 'bricks' ) . ' (PHP)',
			'queryEditorInfo'                             => sprintf(
				// translators: %s: Posts query link, %s: Terms query link, %s: Users query link
				__( 'Return query parameters in PHP array. Learn more about the query parameters for %1$s, %2$s, %3$s', 'bricks' ),
				'<a href="https://developer.wordpress.org/reference/classes/wp_query/#post-type-parameters" target="_blank">' . __( 'Posts', 'bricks' ) . '</a>',
				'<a href="https://developer.wordpress.org/reference/classes/wp_term_query/#source" target="_blank">' . __( 'Terms', 'bricks' ) . '</a>',
				'<a href="https://developer.wordpress.org/reference/classes/wp_user_query/#parameters" target="_blank">' . __( 'Users', 'bricks' ) . '</a>'
			),
			'queryEditorNoCodeExecutionInfo'              => __( 'Query editor in use. But not accessible due to lack of code execution rights.', 'bricks' ),
			'queryFilters'                                => __( 'Query filters', 'bricks' ),
			'queryLoop'                                   => __( 'Query loop', 'bricks' ),
			'queryMaxResultsInfo'                         => Builder::get_query_max_results_info(),

			'radius'                                      => __( 'Radius', 'bricks' ),
			'radial'                                      => __( 'Radial', 'bricks' ),
			'random'                                      => __( 'Random', 'bricks' ),
			'randomSeedTtl'                               => __( 'Random seed TTL', 'bricks' ),
			'randomSeedTtlDescription'                    => __( 'Time in minutes that the random seed will last. Avoid duplicate posts when using random order.', 'bricks' ),
			'raw'                                         => __( 'Raw', 'bricks' ),
			'redo'                                        => __( 'Redo', 'bricks' ),
			'relatedProducts'                             => __( 'Related products', 'bricks' ),
			'relatedProductsQueryDescription'             => __( 'Products with the same category or tag.', 'bricks' ),
			'reload'                                      => __( 'Reload', 'bricks' ),
			'reloadCanvas'                                => __( 'Reload canvas', 'bricks' ),
			'remote'                                      => __( 'Remote', 'bricks' ),
			'remoteTemplates'                             => __( 'Remote templates', 'bricks' ),
			'remove'                                      => __( 'Remove', 'bricks' ),
			'removed'                                     => __( 'Removed', 'bricks' ),
			'removeFile'                                  => __( 'Remove file', 'bricks' ),
			'removeFromIconSet'                           => __( 'Remove from icon set', 'bricks' ),
			'removeSelected'                              => __( 'Remove selected', 'bricks' ),
			'rename'                                      => __( 'Rename', 'bricks' ),
			'renamed'                                     => __( 'Renamed', 'bricks' ),
			'renameImages'                                => __( 'Rename images', 'bricks' ),
			'renameImagesDisabled'                        => __( 'Disabled: Keep original image filename.', 'bricks' ),
			'renameImagesEnabled'                         => __( 'Enabled: Rename image before download.', 'bricks' ),
			'richText'                                    => __( 'Rich Text', 'bricks' ),
			'linkRenderedAs'                              => __( 'Link rendered as', 'bricks' ),
			'repeat'                                      => __( 'Repeat', 'bricks' ),
			'relation'                                    => __( 'Relation', 'bricks' ),
			'restoreIcon'                                 => __( 'Restore icon', 'bricks' ),
			'replace'                                     => __( 'Replace', 'bricks' ),
			'replaceContent'                              => __( 'Replace content', 'bricks' ),
			'replaceContentDisabled'                      => __( 'Disabled: Insert below existing content.', 'bricks' ),
			'replaceContentEnabled'                       => __( 'Enabled: Replace existing content with template data.', 'bricks' ),
			'replaceWith'                                 => __( 'Replace with', 'bricks' ),
			'replaceElementClasses'                       => __( 'Replace element classes', 'bricks' ),
			'replaceElementClassesDesc'                   => __( 'Enable to replace global classes set on the element with the classes set on the property.', 'bricks' ),
			'replaceWithThisString'                       => __( 'Replace with this string', 'bricks' ),
			'responsiveBreakpoints'                       => __( 'Responsive breakpoints', 'bricks' ),
			'reset'                                       => __( 'Reset', 'bricks' ),
			'resetBreakpointsDescription'                 => __( 'Resetting all breakpoints deletes all custom breakpoints and resets all default breakpoints.', 'bricks' ),
			'restore'                                     => __( 'Restore', 'bricks' ),
			'restored'                                    => __( 'Restored', 'bricks' ),
			'restoreSelected'                             => __( 'Restore selected', 'bricks' ),
			'results'                                     => __( 'Results', 'bricks' ),
			'resultsFor'                                  => __( 'results for:', 'bricks' ),
			'reverse'                                     => __( 'Reverse', 'bricks' ),
			'revisionBy'                                  => __( 'Revision by', 'bricks' ),
			'revisionDeleted'                             => __( 'Revision deleted', 'bricks' ),
			'revisionApplied'                             => __( 'Revision applied', 'bricks' ),
			'revisionDiscarded'                           => __( 'Revision discarded', 'bricks' ),
			'revisions'                                   => __( 'Revisions', 'bricks' ),
			'revisionsDeleted'                            => __( 'All revisions deleted', 'bricks' ),
			'right'                                       => __( 'Right', 'bricks' ),
			'roles'                                       => __( 'Roles', 'bricks' ),
			'row'                                         => __( 'Row', 'bricks' ),
			'rows'                                        => __( 'Rows', 'bricks' ),

			'saturation'                                  => __( 'Saturation', 'bricks' ),
			'save'                                        => __( 'Save', 'bricks' ),
			'saveAs'                                      => __( 'Save as', 'bricks' ),
			'saveAsComponent'                             => __( 'Save as component', 'bricks' ),
			'saveDraft'                                   => __( 'Save draft', 'bricks' ),
			'saveAsTemplate'                              => __( 'Save as template', 'bricks' ),
			'saveNewStyle'                                => __( 'Save new style', 'bricks' ),
			'saveStyle'                                   => __( 'Save style', 'bricks' ),
			'saved'                                       => __( 'Saved', 'bricks' ),
			'savedAsTemplate'                             => __( 'Saved as template', 'bricks' ),
			'saveVariables'                               => __( 'Save Variables', 'bricks' ),
			'scale'                                       => __( 'Scale', 'bricks' ),
			'scanningSiteClassesInfo'                     => __( 'Scanning your entire site. This may take a moment.', 'bricks' ),
			'scope'                                       => __( 'Scope', 'bricks' ),
			'screenshotsGenerated'                        => __( 'Screenshots generated', 'bricks' ),
			'scroll'                                      => __( 'Scroll', 'bricks' ),
			'searchElements'                              => __( 'Search elements ..', 'bricks' ),
			'searchFor'                                   => __( 'Type to search for ..', 'bricks' ),
			'searchSettings'                              => __( 'Search settings', 'bricks' ),
			'search'                                      => __( 'Search', 'bricks' ),
			'searchPages'                                 => __( 'Search pages ..', 'bricks' ),
			'searchTemplates'                             => __( 'Search templates ..', 'bricks' ),
			'searchTag'                                   => __( 'Search tag', 'bricks' ),
			'searchVariable'                              => __( 'Search variable', 'bricks' ),
			'section'                                     => __( 'Section', 'bricks' ),
			'select'                                      => __( 'Select', 'bricks' ),
			'selectSvgIcons'                              => __( 'Select SVG Icons', 'bricks' ),
			'selector'                                    => __( 'Selector', 'bricks' ),
			'selectors'                                   => __( 'Selectors', 'bricks' ),
			'selectorExists'                              => __( 'Selector exists', 'bricks' ),
			'selection'                                   => __( 'Selection', 'bricks' ),
			'selectColorPalette'                          => __( 'Select color palette', 'bricks' ),
			'selectedClasses'                             => __( 'Selected classes', 'bricks' ),
			'selectedVariables'                           => __( 'Selected variables', 'bricks' ),
			'setTemplateConditions'                       => __( 'Set conditions', 'bricks' ),
			'selectFile'                                  => __( 'Select file', 'bricks' ),
			'selectFilesToImport'                         => __( 'Select file(s) to import', 'bricks' ),
			'selectIcon'                                  => __( 'Select icon', 'bricks' ),
			'selectImage'                                 => __( 'Select image', 'bricks' ),
			'selectIconSet'                               => __( 'Select icon set', 'bricks' ),
			'selectPostType'                              => __( 'Select post type', 'bricks' ),
			'selectPosts'                                 => __( 'Select posts', 'bricks' ),
			'selectTaxonomies'                            => __( 'Select taxonomies', 'bricks' ),
			'selectTemplate'                              => __( 'Select template', 'bricks' ),
			'selectTemplateTags'                          => __( 'Select template tags', 'bricks' ),
			'selectTemplateType'                          => __( 'Select template type', 'bricks' ),
			'selectTemplateToUpdate'                      => __( 'Select template to update', 'bricks' ),
			'selectTerms'                                 => __( 'Select terms', 'bricks' ),
			'selectTerm'                                  => __( 'Select term', 'bricks' ),
			'selectedElements'                            => __( 'Selected elements', 'bricks' ),
			'selectorDetector'                            => __( 'Selector detector', 'bricks' ),
			'selectorDetectorEmpty'                       => __( 'Select the node that you want to style inside the currently active element on the canvas.', 'bricks' ),
			'selectorDetectorInfo'                        => __( 'Construct the selector you want to create from the node tree below by toggling the relevant selectors.', 'bricks' ),
			'send'                                        => __( 'Send', 'bricks' ),
			'sepia'                                       => __( 'Sepia', 'bricks' ),
			'settings'                                    => __( 'Settings', 'bricks' ),
			'settingsImported'                            => __( 'Settings imported', 'bricks' ),
			'settingsResetted'                            => __( 'Settings resetted', 'bricks' ),
			'solid'                                       => __( 'Solid', 'bricks' ),
			'sort'                                        => __( 'Sort', 'bricks' ),
			'settings'                                    => __( 'Settings', 'bricks' ),
			'shape'                                       => __( 'Shape', 'bricks' ),
			'shapeDividers'                               => __( 'Shape dividers', 'bricks' ),
			'shortcuts'                                   => __( 'Shortcuts', 'bricks' ),
			'showAuthor'                                  => __( 'Show author', 'bricks' ),
			'show'                                        => __( 'Show', 'bricks' ),
			'showDate'                                    => __( 'Show date', 'bricks' ),
			'showEmpty'                                   => __( 'Show empty', 'bricks' ),
			'showElement'                                 => __( 'Show element', 'bricks' ),
			'showExcerpt'                                 => '<a href="https://codex.wordpress.org/Excerpt" target="_blank">' . __( 'Show excerpt', 'bricks' ) . '</a>',
			'showInfo'                                    => __( 'Show info', 'bricks' ),
			'showFullscreen'                              => __( 'Show fullscreen', 'bricks' ),
			'showTitle'                                   => __( 'Show title', 'bricks' ),
			'signAll'                                     => __( 'Sign all', 'bricks' ),
			'signCode'                                    => __( 'Sign code', 'bricks' ),
			'single'                                      => __( 'Single', 'bricks' ),
			'site'                                        => __( 'Site', 'bricks' ),
			'size'                                        => __( 'Size', 'bricks' ),
			'skip'                                        => __( 'Skip', 'bricks' ),
			'slide'                                       => __( 'Slide', 'bricks' ),
			'slider-nested'                               => __( 'Slide', 'bricks' ), // ActionAdd.vue tooltip
			'small'                                       => __( 'Small', 'bricks' ),
			'source'                                      => __( 'Source', 'bricks' ),
			'spaceBetween'                                => __( 'Space between', 'bricks' ),
			'spaceAround'                                 => __( 'Space around', 'bricks' ),
			'spaceEvenly'                                 => __( 'Space evenly', 'bricks' ),
			'spread'                                      => __( 'Spread', 'bricks' ),
			'square'                                      => __( 'Square', 'bricks' ),
			'start'                                       => __( 'Start', 'bricks' ),
			'startingAngle'                               => __( 'Starting angle in º', 'bricks' ),
			'startPlayAt'                                 => __( 'Start play at', 'bricks' ),
			'startTime'                                   => __( 'Start time', 'bricks' ),
			'stretch'                                     => __( 'Stretch', 'bricks' ),
			'strike'                                      => __( 'Strike', 'bricks' ),
			'strikethrough'                               => __( 'Strikethrough', 'bricks' ),
			'strokeColor'                                 => __( 'Stroke color', 'bricks' ),
			'strokeWidth'                                 => __( 'Stroke width', 'bricks' ),
			'structure'                                   => __( 'Structure', 'bricks' ),
			'style'                                       => __( 'Style', 'bricks' ),
			'styles'                                      => __( 'Styles', 'bricks' ),
			'subject'                                     => __( 'Subject', 'bricks' ),
			'suffix'                                      => __( 'Suffix', 'bricks' ),
			'sure'                                        => __( 'Sure?', 'bricks' ),
			'switch'                                      => __( 'Switch', 'bricks' ),
			'svgUploadNotAllowed'                         => __( 'You are not allowed to uploads SVG files.', 'bricks' ),

			'tablet'                                      => __( 'Tablet', 'bricks' ),
			'tag'                                         => __( 'Tag', 'bricks' ),
			'taxonomy'                                    => __( 'Taxonomy', 'bricks' ),
			'taxonomies'                                  => __( 'Taxonomies', 'bricks' ),
			'taxQuery'                                    => __( 'Taxonomy query', 'bricks' ),
			'template'                                    => __( 'Template', 'bricks' ),
			'templateBundle'                              => __( 'Template bundle', 'bricks' ),
			'templateCreated'                             => __( 'Template created', 'bricks' ),
			'templateDeleted'                             => __( 'Template deleted', 'bricks' ),
			'templateImportHint'                          => __( 'Inserting any template overwrites your data. We recommend to save your changes first.', 'bricks' ),
			'templateImported'                            => __( 'Template imported', 'bricks' ),
			'templateInserted'                            => __( 'Template inserted', 'bricks' ),
			'templateInsertErrorNoData'                   => __( 'Template insert failed: This template has no data', 'bricks' ),
			'templateOverridden'                          => __( 'Template overridden', 'bricks' ),
			'templateReleaseSinceCancellation'            => __( 'new templates have been released since you cancelled Bricks.', 'bricks' ),
			'templateSaved'                               => __( 'Template saved', 'bricks' ),
			'templateSettings'                            => __( 'Template settings', 'bricks' ),
			'templateTag'                                 => __( 'Template tag', 'bricks' ),
			'templateTags'                                => __( 'Template tags', 'bricks' ),
			'templateType'                                => __( 'Template type', 'bricks' ),
			'templateTypeDescription'                     => __( 'Select the type of template you want to create:', 'bricks' ),
			'templates'                                   => __( 'Templates', 'bricks' ),
			'terms'                                       => __( 'Terms', 'bricks' ),
			'term'                                        => __( 'Term', 'bricks' ),
			'text'                                        => __( 'Text', 'bricks' ),
			'textAlign'                                   => __( 'Text align', 'bricks' ),
			'textArea'                                    => __( 'Textarea', 'bricks' ),
			'textDecoration'                              => __( 'Text decoration', 'bricks' ),
			'textShadow'                                  => __( 'Text shadow', 'bricks' ),
			'textTransform'                               => __( 'Text transform', 'bricks' ),
			'textWrap'                                    => __( 'Text wrap', 'bricks' ),
			'themeStyle'                                  => __( 'Theme Style', 'bricks' ),
			'themeStyles'                                 => __( 'Theme Styles', 'bricks' ),
			'themeStyleInfoLoadAll'                       => '<a href="' . admin_url( 'admin.php?page=bricks-settings' ) . '" target="_blank">' . __( 'Currently all matching theme styles are loaded. To load only the most specific theme style, adjust your settings under "Theme styles: Loading method".', 'bricks' ) . '</a>',
			'themeStyleInfoLoadSpecific'                  => '<a href="' . admin_url( 'admin.php?page=bricks-settings' ) . '" target="_blank">' . __( 'Currently only the most specific theme style is loaded. To load all matching theme styles, adjust your settings under "Theme styles: Loading method".', 'bricks' ) . '</a>',
			'themeStyleActiveInfo'                        => __( 'Set condition(s) to apply selected theme style to your entire website or certain areas.', 'bricks' ),
			'themeStyleNameExists'                        => __( 'The style name entered already exists. Please choose a different name.', 'bricks' ),
			// translators: %s: Theme Styles link
			'themeStyleSelectInfo'                        => sprintf( __( 'Select a theme style or create a new one to style your website (%s).', 'bricks' ), Helpers::article_link( 'theme-styles', __( 'learn more', 'bricks' ) ) ),
			'themeStyleCreated'                           => __( 'Theme style created', 'bricks' ),
			'themeStyleDeleted'                           => __( 'Theme style deleted', 'bricks' ),
			'themeStyleNewName'                           => __( 'New theme style name', 'bricks' ),
			'themeStyleSaved'                             => __( 'Style saved', 'bricks' ),
			'title'                                       => __( 'Title', 'bricks' ),
			'toggle'                                      => __( 'Toggle', 'bricks' ),
			'top'                                         => __( 'Top', 'bricks' ),
			'topLeft'                                     => __( 'Top left', 'bricks' ),
			'topCenter'                                   => __( 'Top center', 'bricks' ),
			'topRight'                                    => __( 'Top right', 'bricks' ),
			'thumbnail'                                   => __( 'Thumbnail', 'bricks' ),
			'true'                                        => __( 'True', 'bricks' ),
			'type'                                        => __( 'Type', 'bricks' ),
			'typography'                                  => __( 'Typography', 'bricks' ),
			'transform'                                   => [
				'transform'  => __( 'Transform', 'bricks' ),
				'translateX' => __( 'Translate X', 'bricks' ),
				'translateY' => __( 'Translate Y', 'bricks' ),

				'scaleX'     => __( 'Scale X', 'bricks' ),
				'scaleY'     => __( 'Scale Y', 'bricks' ),

				'rotateX'    => __( 'Rotate X', 'bricks' ),
				'rotateY'    => __( 'Rotate Y', 'bricks' ),
				'rotateZ'    => __( 'Rotate Z', 'bricks' ),

				'skewX'      => __( 'Skew X', 'bricks' ),
				'skewY'      => __( 'Skew Y', 'bricks' ),
			],
			'trash'                                       => __( 'Trash', 'bricks' ),
			'trashEmpty'                                  => __( 'Trash is empty', 'bricks' ),

			'unconnected'                                 => __( 'Unconnected', 'bricks' ),
			'unconnectedPropertiesDescription'            => __( 'Unconnected properties detected. Edit your component or any of its children to connect your properties to a specific setting.', 'bricks' ),
			'underline'                                   => __( 'Underline', 'bricks' ),
			'undo'                                        => __( 'Undo', 'bricks' ),
			'unlink'                                      => __( 'Unlink', 'bricks' ),
			'unlinked'                                    => __( 'Unlinked', 'bricks' ),
			'unlinkComponent'                             => __( 'Unlink component', 'bricks' ),
			'unlinkComponentConfirm'                      => __( 'Are you sure you want to unlink this component?', 'bricks' ),
			'unlock'                                      => __( 'Unlock', 'bricks' ),
			'unlocked'                                    => __( 'Unlocked', 'bricks' ),
			'unsplashErrorInvalidApiKey'                  => __( 'Your Unsplash API key is not valid.', 'bricks' ),
			'unsplashErrorNoApiKey'                       => sprintf(
				// translators: %s: API keys link
				__( 'Unsplash API key required! Add key in dashboard under: %s', 'bricks' ),
				'<a href="' . Helpers::settings_url( '#tab-api-keys' ) . '" target="_blank">Bricks > ' . __( 'Settings', 'bricks' ) . ' > API keys</a>'
			),
			'unsplashErrorRateLimitReached'               => __( 'Rate limit for this hour reached. Please wait until the next full hour for it to be resetted.', 'bricks' ),
			'unsplashSearchPlaceholder'                   => __( 'Type keyword, hit enter.', 'bricks' ),

			'uncategorized'                               => __( 'Uncategorized', 'bricks' ),
			'understandingTheLayout'                      => __( 'Understanding the layout', 'bricks' ),
			'unitTooltip'                                 => __( 'Select/enter unit', 'bricks' ),
			'unpin'                                       => __( 'Unpin', 'bricks' ),
			'unpinned'                                    => __( 'Unpinned', 'bricks' ),
			'unsignedCode'                                => __( 'Unsigned code', 'bricks' ),
			'unsplashSetApiKey'                           => '<a href="' . Helpers::settings_url( '#tab-api-keys' ) . '" class="button" target="_blank">' . __( 'Set Unsplash API Key', 'bricks' ) . '</a>',
			'unusedOnThisPage'                            => __( 'Unused on this page', 'bricks' ),
			'unusedOnThisSite'                            => __( 'Unused on this site', 'bricks' ),
			'unwrap'                                      => __( 'Unwrap', 'bricks' ),
			'update'                                      => __( 'Update', 'bricks' ),
			'updatingVariableReferences'                  => __( 'Updating references to %s global variable(s) across the entire site...', 'bricks' ),
			'updated'                                     => __( 'Updated', 'bricks' ),
			'upload'                                      => __( 'Upload', 'bricks' ),
			'uppercase'                                   => __( 'Uppercase', 'bricks' ),
			'upSells'                                     => __( 'Upsells', 'bricks' ),
			'upSellsQueryDescription'                     => __( 'Place this query on the single product page.', 'bricks' ),
			'uploadSvg'                                   => __( 'Upload SVG', 'bricks' ),
			'urlParameters'                               => __( 'URL parameters', 'bricks' ),
			'usedOnThisPage'                              => __( 'Used on this page', 'bricks' ),
			'usedOnThisSite'                              => __( 'Used on this site', 'bricks' ),
			'useMinMax'                                   => __( 'Use min/max', 'bricks' ),
			'useMinMaxDescription'                        => sprintf( __( 'Use %s when adding columns/rows', 'bricks' ), 'minmax(0, 1fr)' ),
			'userProfile'                                 => __( 'User profile', 'bricks' ),

			'value'                                       => __( 'Value', 'bricks' ),
			'variableNameExists'                          => __( 'Variable name already exists', 'bricks' ),
			'variable'                                    => __( 'Variable', 'bricks' ),
			'variables'                                   => __( 'Variables', 'bricks' ),
			'variablesDuplicated'                         => __( 'Variables duplicated', 'bricks' ),
			'variablesImported'                           => __( 'Variables imported', 'bricks' ),
			'variablesRenamed'                            => __( 'Variables renamed', 'bricks' ),
			'variableCategoriesImportConfirm'             => __( 'Would you like to import the variable categories as well?', 'bricks' ),
			'variableName'                                => __( 'Variable name', 'bricks' ),
			'variableNamePlaceholder'                     => __( 'New variable name', 'bricks' ),
			'variableNewNoName'                           => __( 'Variable name missing', 'bricks' ),
			'variableNewAlreadyExists'                    => __( 'Variable name already exists', 'bricks' ),
			'vertical'                                    => __( 'Vertical', 'bricks' ),
			'verticalAlignment'                           => __( 'Vertical alignment', 'bricks' ),
			'video'                                       => __( 'Video', 'bricks' ),
			'videoUrl'                                    => __( 'Video URL', 'bricks' ),
			'view'                                        => __( 'View', 'bricks' ),
			'viewClasses'                                 => __( 'View classes', 'bricks' ),
			'viewOnFrontend'                              => __( 'View on frontend', 'bricks' ),
			'visible'                                     => __( 'Visible', 'bricks' ),
			'visibility'                                  => __( 'Visibility', 'bricks' ),
			'visitDocs'                                   => __( 'Visit docs', 'bricks' ),
			'visualGridBuilder'                           => __( 'Visual grid builder', 'bricks' ),

			'whiteSpace'                                  => __( 'White space', 'bricks' ),
			'width'                                       => __( 'Width', 'bricks' ),
			'willOverrideLocal'                           => __( 'Will override local', 'bricks' ),
			'woocommerce_product'                         => __( 'Product', 'bricks' ),
			'wordpress'                                   => 'WordPress',
			'wrap'                                        => __( 'Wrap', 'bricks' ),
			'nowrap'                                      => __( 'No wrap', 'bricks' ),
			'wrap-reverse'                                => __( 'Wrap reverse', 'bricks' ),

			'xAxis'                                       => __( 'X axis', 'bricks' ),
			'yAxis'                                       => __( 'Y axis', 'bricks' ),

			'yes'                                         => __( 'Yes', 'bricks' ),
			'you'                                         => __( 'You', 'bricks' ),
			'youAreMissingOut'                            => __( 'You are missing out!', 'bricks' ),

			'zIndex'                                      => __( 'Z-index', 'bricks' ),
			'zoom'                                        => __( 'Zoom', 'bricks' ),
			'errorCreatingFont'                           => __( 'Failed to create font', 'bricks' ),
			'errorMovingFontToTrash'                      => __( 'Failed to move font to trash.', 'bricks' ),
			'errorDeletingFont'                           => __( 'Failed to delete font', 'bricks' ),
			'errorProcessingFontFiles'                    => __( 'Error processing font files', 'bricks' ),
			'errorUploadingFont'                          => __( 'Error uploading font', 'bricks' ),
			'invalidFontFile'                             => __( 'Invalid font file', 'bricks' ),
			'removeFromFavorites'                         => __( 'Remove from favorites', 'bricks' ),
			'selectFontFile'                              => __( 'Select font file', 'bricks' ),
		];
	}

	public static function get_all_i18n() {
		$admin_i18n            = self::get_admin_i18n();
		$builder_i18n          = self::get_builder_i18n();
		$frontend_translations = self::get_frontend_i18n();

		// Merge admin translations into builder and frontend translations.
		$all_translations = array_merge( $admin_i18n, $builder_i18n, $frontend_translations );

		return $all_translations;
	}
}
